#ifndef ETPAN_ACCOUNT_MANAGER

#define ETPAN_ACCOUNT_MANAGER

#include "etpan-account-manager-types.h"
#include "etpan-account-types.h"

struct etpan_account_manager * etpan_account_manager_new(void);

void etpan_account_manager_free(struct etpan_account_manager * manager);

chash * etpan_account_manager_get_account_hash(struct etpan_account_manager *
    manager);

struct etpan_account *
etpan_account_manager_get_account(struct etpan_account_manager * manager,
    char * name);

void etpan_account_manager_add_account(struct etpan_account_manager * manager,
    struct etpan_account * account);

void etpan_account_manager_remove_account(struct etpan_account_manager *
    manager, struct etpan_account * account);

void etpan_account_manager_set_default(struct etpan_account_manager * manager);
struct etpan_account_manager * etpan_account_manager_get_default(void);

carray * etpan_account_manager_get_ordered_list(struct etpan_account_manager * manager);

void etpan_account_manager_notify_modification(struct etpan_account_manager * manager);

char *
etpan_account_manager_get_path(struct etpan_account_manager * manager);

void etpan_account_manager_set_path(struct etpan_account_manager * manager,
    char * path);

void etpan_account_manager_stop(struct etpan_account_manager * manager,
    void (* callback)(void *), void * cb_data);

void etpan_account_manager_setup(struct etpan_account_manager * manager);
void etpan_account_manager_unsetup(struct etpan_account_manager * manager);

#endif
