#ifndef ETPAN_ACCOUNT_H

#define ETPAN_ACCOUNT_H

#include "etpan-account-types.h"
#include "etpan-folder-types.h"

struct etpan_account * etpan_account_new(void);
void etpan_account_free(struct etpan_account * account);

/* set and get identifier of the account */
void etpan_account_set_id(struct etpan_account * account, char * id);
char * etpan_account_get_id(struct etpan_account * account);

/* name */
void etpan_account_set_display_name(struct etpan_account * account,
    char * name);
char * etpan_account_get_display_name(struct etpan_account * account);

/* mail */
void etpan_account_set_mail(struct etpan_account * account, char * mail);
char * etpan_account_get_mail(struct etpan_account * account);

/* get sender and storage */
struct etpan_storage *
etpan_account_get_storage(struct etpan_account * account);
carray * etpan_account_get_outbox_list(struct etpan_account * account);

/* set storage */
void etpan_account_set_storage(struct etpan_account * account,
    struct etpan_storage * storage);
carray * etpan_account_get_outbox_list(struct etpan_account * account);
void etpan_account_add_outbox(struct etpan_account * account,
    struct etpan_outbox * outbox);
void etpan_account_remove_outbox(struct etpan_account * account,
    struct etpan_outbox * outbox);

/* set special folders */
void etpan_account_set_special_folder_by_location(struct etpan_account * account,
    char * name, char * location);

void etpan_account_set_draft_by_location(struct etpan_account * account,
    char * draft);
void etpan_account_set_sent_by_location(struct etpan_account * account,
    char * sent);
void etpan_account_set_trash_by_location(struct etpan_account * account,
    char * trash);

void etpan_account_set_special_folder(struct etpan_account * account,
    char * name, struct etpan_folder * folder);
void etpan_account_set_draft(struct etpan_account * account,
    struct etpan_folder * draft);
void etpan_account_set_sent(struct etpan_account * account,
    struct etpan_folder * sent);
void etpan_account_set_trash(struct etpan_account * account,
    struct etpan_folder * trash);

/* get special folders */
struct etpan_folder *
etpan_account_get_special_folder(struct etpan_account * account,
    char * name);
struct etpan_folder * etpan_account_get_draft(struct etpan_account * account);
struct etpan_folder * etpan_account_get_sent(struct etpan_account * account);
struct etpan_folder * etpan_account_get_trash(struct etpan_account * account);

void etpan_account_stop(struct etpan_account * account,
    void (* callback)(void *), void * cb_data);

struct etpan_error * etpan_account_setup(struct etpan_account * account) WARN_UNUSED_RESULT;
void etpan_account_unsetup(struct etpan_account * account);

#endif
