#include "etpan-address.h"

#include <stdlib.h>
#include <string.h>

#include "etpan-log.h"
#include "etpan-error.h"

struct etpan_address * etpan_address_new(void)
{
  struct etpan_address * addr;
  
  addr = malloc(sizeof(* addr));
  if (addr == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  addr->display_name = NULL;
  addr->address = NULL;
  
  return addr;
}

void etpan_address_free(struct etpan_address * addr)
{
  free(addr->display_name);
  free(addr->address);
  free(addr);
}

char * etpan_address_get_display_name(struct etpan_address * addr)
{
  return addr->display_name;
}

void etpan_address_set_display_name(struct etpan_address * addr,
    char * display_name)
{
  if (display_name != addr->display_name) {
    free(addr->display_name);
    if (display_name != NULL) {
      addr->display_name = strdup(display_name);
      if (addr->display_name == NULL)
        ETPAN_LOG_MEMORY_ERROR;
    }
    else
      addr->display_name = NULL;
  }
}

char * etpan_address_get_address(struct etpan_address * addr)
{
  return addr->address;
}

void etpan_address_set_address(struct etpan_address * addr,
    char * address)
{
  if (address != addr->address) {
    free(addr->address);
    if (address != NULL) {
      addr->address = strdup(address);
      if (addr->address == NULL)
        ETPAN_LOG_MEMORY_ERROR;
    }
    else
      addr->address = NULL;
  }
}

carray * etpan_address_list_new(void)
{
  return carray_new(4);
}

void etpan_address_list_free(carray * addr_list)
{
  unsigned int i;
  
  for(i = 0 ; i < carray_count(addr_list) ; i ++) {
    struct etpan_address * addr;
    
    addr = carray_get(addr_list, i);
    etpan_address_free(addr);
  }
  
  carray_free(addr_list);
}

void etpan_address_list_add_address(carray * addr_list,
    struct etpan_address * addr)
{
  int r;
  
  r = carray_add(addr_list, addr, NULL);
  if (r < 0)
    ETPAN_LOG_MEMORY_ERROR;
}

struct etpan_address * etpan_address_dup(struct etpan_address * addr)
{
  struct etpan_address * dup_addr;
  
  dup_addr = etpan_address_new();
  
  etpan_address_set_display_name(dup_addr,
      etpan_address_get_display_name(addr));
  
  etpan_address_set_address(dup_addr,
      etpan_address_get_address(addr));
  
  return dup_addr;
}

carray * etpan_address_list_dup(carray * addr_list)
{
  unsigned int i;
  carray * dup_addr_list;
  
  dup_addr_list = etpan_address_list_new();
  
  for(i = 0 ; i < carray_count(addr_list) ; i ++) {
    struct etpan_address * addr;
    struct etpan_address * dup_addr;
    
    addr = carray_get(addr_list, i);
    dup_addr = etpan_address_dup(addr);
    
    etpan_address_list_add_address(dup_addr_list, dup_addr);
  }
  
  return dup_addr_list;
}
