#ifndef ETPAN_ADDRESS_H

#define ETPAN_ADDRESS_H

#include <libetpan/libetpan.h>

#include "etpan-address-types.h"

struct etpan_address * etpan_address_new(void);
void etpan_address_free(struct etpan_address * addr);

char * etpan_address_get_display_name(struct etpan_address * addr);
void etpan_address_set_display_name(struct etpan_address * addr,
    char * display_name);

char * etpan_address_get_address(struct etpan_address * addr);
void etpan_address_set_address(struct etpan_address * addr,
    char * address);

carray * etpan_address_list_new(void);
void etpan_address_list_free(carray * addr_list);
void etpan_address_list_add_address(carray * addr_list,
    struct etpan_address * addr);

struct etpan_address * etpan_address_dup(struct etpan_address * addr);

carray * etpan_address_list_dup(carray * addr_list);

#endif
