#ifndef ETPAN_BOOKMARK_H

#define ETPAN_BOOKMARK_H

#include "etpan-bookmark-types.h"
#include "etpan-folder-types.h"
#include "etpan-account-manager-types.h"

struct etpan_bookmark_manager * etpan_bookmark_manager_new(void);
void etpan_bookmark_manager_free(struct etpan_bookmark_manager * manager);

carray *
etpan_bookmark_manager_get_list(struct etpan_bookmark_manager * manager);

void etpan_bookmark_manager_add(struct etpan_bookmark_manager * manager,
    struct etpan_bookmark * item);
void etpan_bookmark_manager_remove(struct etpan_bookmark_manager * manager,
    struct etpan_bookmark * item);

struct etpan_bookmark * etpan_bookmark_new(void);
void etpan_bookmark_free(struct etpan_bookmark * bookmark);

void etpan_bookmark_set_display_name(struct etpan_bookmark * bookmark,
    char * display_name);
char * etpan_bookmark_get_display_name(struct etpan_bookmark * bookmark);

void etpan_bookmark_set_storage(struct etpan_bookmark * bookmark,
    char * storage);
char * etpan_bookmark_get_storage(struct etpan_bookmark * bookmark);

void etpan_bookmark_set_location(struct etpan_bookmark * bookmark,
    char * location);
char * etpan_bookmark_get_location(struct etpan_bookmark * bookmark);

void etpan_bookmark_manager_set_default(struct etpan_bookmark_manager *
    manager);
struct etpan_bookmark_manager * etpan_bookmark_manager_get_default(void);

struct etpan_folder *
etpan_bookmark_get_folder(struct etpan_account_manager * manager,
    struct etpan_bookmark * bookmark);

#endif
