#ifndef ETPAN_ERROR_TYPES_H

#define ETPAN_ERROR_TYPES_H

#include <libetpan/libetpan.h>

#define ETPAN_ERROR_FREE(error) \
    do { \
      if (error != NULL) \
      etpan_error_free(error); \
    } \
    while (0)

#define ETPAN_ERROR_IGNORE(error) \
    ETPAN_ERROR_FREE(error)

/* warning on unused results */
#if    __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#define WARN_UNUSED_RESULT 		\
  __attribute__((warn_unused_result))
#else
#define WARN_UNUSED_RESULT
#endif /* __GNUC__ */

struct etpan_error {
  int code;
  char * short_description;
  char * long_description;
  
  carray * children;
};

enum {
  /*
  NO_ERROR = 0,
  */
  ERROR_INTERNAL = 1,
  ERROR_MULTIPLE,
  ERROR_CACHE,
  ERROR_CONFIG,
  ERROR_INVAL,
  ERROR_PARSE,
  ERROR_MOVE,
  ERROR_COPY,
  ERROR_MSG_LIST,
  ERROR_ENV_LIST, /* 10 */
  ERROR_CONNECT,
  ERROR_FETCH,
  ERROR_APPEND,
  ERROR_SEND,
  ERROR_NOT_IMPLEMENTED,
  ERROR_FILE,
  ERROR_TOO_MUCH_RECIPIENT,
  ERROR_COMMAND,
  ERROR_STREAM,
  ERROR_CANCELLED, /* 20 */
  ERROR_CREATE,
  ERROR_DELETE,
  ERROR_UNKNOWN_PROTOCOL,
  ERROR_COULD_NOT_ENCRYPT,
  ERROR_CHECK,
  ERROR_STATUS,
  ERROR_EXPUNGE,
  ERROR_MARK_AS_SPAM,
  ERROR_BUSY,
  ERROR_NEWSGROUPS_LIST,
  ERROR_IMAP_MAILBOX_LIST, /* 30 */
  ERROR_IMAP_CREATE,
  ERROR_IMAP_RENAME,
  ERROR_IMAP_SUBSCRIBE,
  ERROR_IMAP_UNSUBSCRIBE,
  ERROR_IMAP_EXPUNGE,
  ERROR_IMAP_STORE,
  ERROR_IMAP_APPEND,
  ERROR_IMAP_STATUS,
  ERROR_PRIVACY,
  ERROR_FOLDER_NOT_FOUND,
  ERROR_LDAP_SEARCH,
  ERROR_NOT_SUPPORTED,
  ERROR_COULD_NOT_POSTPONE,
  ERROR_NO_FROM,
  ERROR_NO_RECIPIENT,
  ERROR_AUTH,
  ERROR_EXISTS,
  ERROR_DISPLAY,
  ERROR_LDAP,
  ERROR_SYSTEM,
  ERROR_READONLY,
  ERROR_PART_NOT_FOUND,
  ERROR_DATABASE,
};

#endif
