#ifndef ETPAN_ERROR_H

#define ETPAN_ERROR_H

#include "etpan-error-types.h"

struct etpan_error * etpan_error_new(void);
void etpan_error_free(struct etpan_error * error);

void etpan_error_set_code(struct etpan_error * error, int code);
int etpan_error_get_code(struct etpan_error * error);

void etpan_error_set_short_description(struct etpan_error * error,
    char * short_description);
char * etpan_error_get_short_description(struct etpan_error * error);

void etpan_error_set_long_description(struct etpan_error * error,
    char * long_description);
char * etpan_error_get_long_description(struct etpan_error * error);

void etpan_error_add_child(struct etpan_error * parent,
    struct etpan_error * child);
carray * etpan_error_get_children(struct etpan_error * parent);

/* helper */

struct etpan_error * etpan_error_dup(struct etpan_error * error);

void etpan_error_strf_long_description(struct etpan_error * error,
    char * format, ...);

struct etpan_error *
etpan_error_set_from_error(struct etpan_error * previous_error,
    char * format, ...);

int etpan_error_is_cancelled(struct etpan_error * error);

int etpan_error_has_code(struct etpan_error * error, int error_code);

struct etpan_error * etpan_error_internal(char * long_description);

struct etpan_error * etpan_error_internal_strf(char * format, ...);

struct etpan_error * etpan_error_multiple(void);

void etpan_error_log(struct etpan_error * error);

#endif
