#ifndef ETPAN_FOLDER_COPY_TYPES_H

#define ETPAN_FOLDER_COPY_TYPES_H

#include "etpan-message-copy-types.h"
#include "etpan-folder-create-types.h"
#include "etpan-folder-delete-types.h"
#include "etpan-msg-list-fetch-types.h"

#define ETPAN_FOLDER_COPY_FINISHED_SIGNAL \
  "org.etpan.folder-copy.finished"

struct etpan_folder_copy {
  int ref_count;
  struct etpan_folder * source_folder;
  struct etpan_storage * dest_storage;
  struct etpan_folder * dest_folder;
  struct etpan_folder * created_folder;
  struct etpan_message_copy * msg_copy;
  struct etpan_folder_copy * subfolder_copy;
  struct etpan_folder_create * folder_create;
  struct etpan_folder_delete * folder_delete;
  int opened;
  carray * foldertab;
  unsigned int next_folder;
  int delete;
  char * dest_location;
  struct etpan_error * error;
  int state;
  carray * error_list;
  unsigned int copy_msg_id;
};

#endif
