#ifndef ETPAN_FOLDER_COPY_H

#define ETPAN_FOLDER_COPY_H

#include "etpan-folder-copy-types.h"

struct etpan_folder_copy * etpan_folder_copy_new(void);

void etpan_folder_copy_ref(struct etpan_folder_copy * folder_copy);
void etpan_folder_copy_unref(struct etpan_folder_copy * folder_copy);

void etpan_folder_copy_set_delete(struct etpan_folder_copy * folder_copy,
    int delete);
int etpan_folder_copy_get_delete(struct etpan_folder_copy * folder_copy);

void etpan_folder_copy_set_source(struct etpan_folder_copy * folder_copy,
    struct etpan_folder * source_folder);
struct etpan_folder *
etpan_folder_copy_get_source(struct etpan_folder_copy * folder_copy);

void etpan_folder_copy_set_dest_storage(struct etpan_folder_copy * folder_copy,
    struct etpan_storage * dest_storage);
struct etpan_storage *
etpan_folder_copy_get_dest_storage(struct etpan_folder_copy * folder_copy);

void etpan_folder_copy_set_dest_folder(struct etpan_folder_copy * folder_copy,
    struct etpan_folder * dest_folder);
struct etpan_folder *
etpan_folder_copy_get_dest_folder(struct etpan_folder_copy * folder_copy);

void etpan_folder_copy_setup(struct etpan_folder_copy * folder_copy);

void etpan_folder_copy_run(struct etpan_folder_copy * folder_copy);
void etpan_folder_copy_cancel(struct etpan_folder_copy * folder_copy);

struct etpan_error *
etpan_folder_copy_get_error(struct etpan_folder_copy * folder_copy);

struct etpan_folder *
etpan_folder_copy_get_created_folder(struct etpan_folder_copy * folder_copy);

#endif
