#ifndef ETPAN_FOLDER_CREATE_H

#define ETPAN_FOLDER_CREATE_H

#include "etpan-folder-create-types.h"

struct etpan_folder_create * etpan_folder_create_new(void);

void etpan_folder_create_ref(struct etpan_folder_create * folder_create);
void etpan_folder_create_unref(struct etpan_folder_create * folder_create);

void etpan_folder_create_set_folder_name(struct etpan_folder_create * folder_create, char * name);
char * etpan_folder_create_get_folder_name(struct etpan_folder_create * folder_create);

void etpan_folder_create_set_parent_folder(struct etpan_folder_create * folder_create,
    struct etpan_folder * parent_folder);
struct etpan_folder *
etpan_folder_create_get_parent_folder(struct etpan_folder_create * folder_create);

void etpan_folder_create_set_storage(struct etpan_folder_create * folder_create,
    struct etpan_storage * storage);
struct etpan_storage *
etpan_folder_create_get_storage(struct etpan_folder_create * folder_create);

void etpan_folder_create_setup(struct etpan_folder_create * folder_create);

void etpan_folder_create_run(struct etpan_folder_create * folder_create);
void etpan_folder_create_cancel(struct etpan_folder_create * folder_create);

struct etpan_error * etpan_folder_create_get_error(struct etpan_folder_create * folder_create);

struct etpan_folder *
etpan_folder_create_get_created_folder(struct etpan_folder_create * folder_create);

#endif
