#ifndef ETPAN_FOLDER_INDEXER_TYPES_H

#define ETPAN_FOLDER_INDEXER_TYPES_H

#include "etpan-indexer-types.h"
#include "etpan-message-fetcher-types.h"
#include <libetpan/libetpan.h>

#define ETPAN_FOLDER_INDEXER_START \
  "org.etpan.folder-indexer.start"

#define ETPAN_FOLDER_INDEXER_UPDATED_RESULT \
  "org.etpan.folder-indexer.updated-result"

#define ETPAN_FOLDER_INDEXER_FINISHED \
  "org.etpan.folder-indexer.finished"

#define ETPAN_FOLDER_INDEXER_STATE_CHANGED \
  "org.etpan.folder-indexer.state-changed"

enum {
  ETPAN_FOLDER_INDEXER_SEARCH_TYPE_ALL,
  ETPAN_FOLDER_INDEXER_SEARCH_TYPE_FROM_AND_SUBJECT,
  ETPAN_FOLDER_INDEXER_SEARCH_TYPE_RECIPIENT_AND_SUBJECT,
  ETPAN_FOLDER_INDEXER_SEARCH_TYPE_FROM,
  ETPAN_FOLDER_INDEXER_SEARCH_TYPE_SUBJECT,
  ETPAN_FOLDER_INDEXER_SEARCH_TYPE_RECIPIENT,
  ETPAN_FOLDER_INDEXER_SEARCH_TYPE_BODY,
};

enum {
  ETPAN_FOLDER_INDEXER_STATE_IDLE,
  ETPAN_FOLDER_INDEXER_STATE_INDEXING_HEADERS,
  ETPAN_FOLDER_INDEXER_STATE_INDEXING_BODY,
};

struct etpan_folder_indexer {
  char * path;
  struct etpan_folder * folder;
  
  int dirty;
  int state;
  
  /* get indexer state */
  int indexer_state_initialized;
  struct etpan_thread_op * get_indexer_state_op;
  
  /* header indexer */
  chash * current_messages_hash;
  chash * new_messages_hash;
  carray * deleted_messages_list;
  struct etpan_thread_op * indexing_op;
  struct etpan_indexer * indexer;
  
  /* body indexer */
  chash * body_current_messages_hash;
  chash * body_new_messages_hash;
  carray * body_new_messages_list;
  carray * body_deleted_messages_list;
  unsigned int body_next_msg;
  struct etpan_message_fetcher * fetcher;
  struct etpan_thread_op * body_indexing_op;
  struct etpan_indexer * body_indexer;
  
  /* search */
  struct etpan_thread_op * search_op;
  
  carray * error_list;
  struct etpan_error * error;
  int cancelled;
};

struct etpan_folder_indexer_search_result {
  struct etpan_error * error;
  carray * messages;
};

#endif
