#ifndef ETPAN_FOLDER_INDEXER_H

#define ETPAN_FOLDER_INDEXER_H

#include "etpan-folder-indexer-types.h"

struct etpan_folder_indexer * etpan_folder_indexer_new(void);
void etpan_folder_indexer_free(struct etpan_folder_indexer * fi);

void etpan_folder_indexer_setup(struct etpan_folder_indexer * fi);
void etpan_folder_indexer_unsetup(struct etpan_folder_indexer * fi);

void etpan_folder_indexer_set_path(struct etpan_folder_indexer * fi,
    char * path);
char * etpan_folder_indexer_get_path(struct etpan_folder_indexer * fi);

void etpan_folder_indexer_set_folder(struct etpan_folder_indexer * fi,
    struct etpan_folder * folder);
struct etpan_folder * etpan_folder_indexer_get_folder(struct etpan_folder_indexer * fi);

void etpan_folder_indexer_update(struct etpan_folder_indexer * fi);

void etpan_folder_search_simple(struct etpan_folder_indexer * fi,
    int search_type, char * text,
    void (* callback)(int cancelled,
        struct etpan_folder_indexer_search_result * result, void * cb_data),
    void * cb_data);

void etpan_folder_search(struct etpan_folder_indexer * fi,
    char * expr_headers,
    char * expr_body,
    void (* callback)(int cancelled,
        struct etpan_folder_indexer_search_result * result, void * cb_data),
    void * cb_data);

char * etpan_folder_indexer_get_path_for_folder(struct etpan_folder_indexer * fi);

void etpan_folder_indexer_cancel_search(struct etpan_folder_indexer * fi);

int etpan_folder_indexer_indexing_state(struct etpan_folder_indexer * fi);

struct etpan_error *
etpan_folder_indexer_get_error(struct etpan_folder_indexer * fi);

int etpan_folder_indexer_is_searching(struct etpan_folder_indexer * fi);

#endif
