#ifndef ETPAN_FOLDER_RENAME_H

#define ETPAN_FOLDER_RENAME_H

#include "etpan-folder-rename-types.h"

struct etpan_folder_rename * etpan_folder_rename_new(void);

void etpan_folder_rename_ref(struct etpan_folder_rename * folder_rename);
void etpan_folder_rename_unref(struct etpan_folder_rename * folder_rename);

void etpan_folder_rename_set_folder(struct etpan_folder_rename * folder_rename,
    struct etpan_folder * folder);
struct etpan_folder *
etpan_folder_rename_get_folder(struct etpan_folder_rename * folder_rename);

void etpan_folder_rename_set_new_name(struct etpan_folder_rename * folder_rename, char * new_name);
char * etpan_folder_rename_get_new_name(struct etpan_folder_rename * folder_rename);

void etpan_folder_rename_setup(struct etpan_folder_rename * folder_rename);

void etpan_folder_rename_run(struct etpan_folder_rename * folder_rename);
void etpan_folder_rename_cancel(struct etpan_folder_rename * folder_rename);

struct etpan_error *
etpan_folder_rename_get_error(struct etpan_folder_rename * folder_rename);

struct etpan_folder *
etpan_folder_rename_get_renamed_folder(struct etpan_folder_rename * folder_rename);

#endif
