#ifndef ETPAN_FOLDER_TREE_H

#define ETPAN_FOLDER_TREE_H

#include "etpan-folder-tree-types.h"

struct etpan_folder_tree * etpan_folder_tree_new(void);
void etpan_folder_tree_free(struct etpan_folder_tree * folder_tree);

void etpan_folder_tree_free_recursive(struct etpan_folder_tree * folder_tree);

void etpan_folder_tree_set_ui_path(struct etpan_folder_tree * folder_tree,
    char * ui_path);
char * etpan_folder_tree_get_ui_path(struct etpan_folder_tree * folder_tree);

void etpan_folder_tree_set_folder(struct etpan_folder_tree * folder_tree,
    struct etpan_folder * folder);
struct etpan_folder *
etpan_folder_tree_get_folder(struct etpan_folder_tree * folder_tree);

struct etpan_folder_tree *
etpan_folder_tree_get_parent(struct etpan_folder_tree * child);
void etpan_folder_tree_set_parent(struct etpan_folder_tree * child,
    struct etpan_folder_tree * parent);

void etpan_folder_tree_add_child(struct etpan_folder_tree * parent,
    struct etpan_folder_tree * child);
carray * etpan_folder_tree_get_children(struct etpan_folder_tree * parent);

/* helper */
struct etpan_folder_tree * etpan_folder_tree_get_node(struct etpan_folder_tree * parent, char * folder_name);

#endif
