#ifndef ETPAN_FOLDER_TYPES_H

#define ETPAN_FOLDER_TYPES_H

#include <libetpan/libetpan.h>
#include "etpan-message-types.h"
#include "etpan-error-types.h"

#define ETPAN_FOLDER_COUNT_UPDATED \
  "org.etpan.folder.count-updated"

#define ETPAN_FOLDER_MSGLIST_UPDATED \
  "org.etpan.folder.msglist-updated"

#define SPECIAL_FOLDER_TRASH "trash"
#define SPECIAL_FOLDER_OUTBOX "outbox"
#define SPECIAL_FOLDER_SENT "sent"
#define SPECIAL_FOLDER_DRAFT "draft"

struct etpan_folder;

struct etpan_folder_driver {
  char * name;
  
  /* hash must be created with key copy option */
  struct etpan_error * (* fetch_msg_list)(struct etpan_folder * folder,
      chash * current_msg_list) WARN_UNUSED_RESULT;
  
  struct etpan_error * (* append_msg)(struct etpan_folder * folder,
      char * message, size_t size,
      struct etpan_message_flags * flags) WARN_UNUSED_RESULT;
  
  struct etpan_error * (* check)(struct etpan_folder * folder) WARN_UNUSED_RESULT;
  
  struct etpan_error * (* status)(struct etpan_folder * folder,
      unsigned int * p_count, unsigned int * p_unseen, unsigned int * p_recent) WARN_UNUSED_RESULT;
  
  struct etpan_error * (* expunge)(struct etpan_folder * folder) WARN_UNUSED_RESULT;
  
  void (* free_data)(struct etpan_folder * folder);
  
  struct etpan_error * (* setup)(struct etpan_folder * folder) WARN_UNUSED_RESULT;
  
  struct etpan_error * (* connect)(struct etpan_folder * folder) WARN_UNUSED_RESULT;
  void (* disconnect)(struct etpan_folder * folder);
  
  int (* is_sub_folder)(struct etpan_folder * parent,
      struct etpan_folder * child);
};

struct etpan_folder {
  int ref_count;
  struct etpan_storage * storage;
  
  /* server info */
  char * location;
  unsigned int max;
  
  int lost;
  char * uid;
  int show_unfiltered;
  
  char * default_recipient; 
  /* trash, outbox, draft, sent */
  chash * special_folder_list;  /* XXX - must be set by storage and folder */
  
  /* persistent ui info, ui_name is implicitely set using ui_path */
  char * ui_name;
  char * ui_path;
  int poll;
  
  /* non-persistent ui info */
  int info_fetched;
  unsigned int total;
  /* don't use recent directly, try to use a better hint ... */
  unsigned int recent;
  unsigned int unseen;
  
  int message_list_fetched;
  chash * message_list;
  int ref_msg_list;
  
  void * data;
  struct etpan_folder_driver * driver;
  
  /* threaded */
  char * threaded_location;
  char * threaded_uid;
};

struct etpan_folder_fetch_msg_list_result {
  struct etpan_error * error;
  chash * current_message_list;
};

struct etpan_folder_check_result {
  struct etpan_error * error;
};

struct etpan_folder_status_result {
  struct etpan_error * error;
  unsigned int count;
  unsigned int unseen;
  unsigned int recent;
};

struct etpan_folder_expunge_result {
  struct etpan_error * error;
};

struct etpan_folder_append_msg_result {
  struct etpan_error * error;
};

struct etpan_folder_check_msg_list_result {
  struct etpan_error * error;
};

#endif
