#ifndef ETPAN_FOLDER_VIEW_H

#define ETPAN_FOLDER_VIEW_H

#include "etpan-folder-view-types.h"

struct etpan_folder_view * etpan_folder_view_new(void);
void etpan_folder_view_free(struct etpan_folder_view * view);

void etpan_folder_view_setup(struct etpan_folder_view * view);
void etpan_folder_view_unsetup(struct etpan_folder_view * view);

void etpan_folder_view_set_flags(struct etpan_folder_view * view,
    int flags);

void etpan_folder_view_set_folder(struct etpan_folder_view * view,
    struct etpan_folder * folder);
void etpan_folder_view_add_folder(struct etpan_folder_view * view,
    struct etpan_folder * folder);
void etpan_folder_view_remove_folder(struct etpan_folder_view * view,
    struct etpan_folder * folder);

struct etpan_msg_list_view *
etpan_folder_view_get_msg_list_view(struct etpan_folder_view * view);

void etpan_folder_view_search_simple(struct etpan_folder_view * view,
    int search_type, char * text);

void etpan_folder_view_search(struct etpan_folder_view * view,
    char * expr_headers,
    char * expr_body);

void etpan_folder_view_cancel_search(struct etpan_folder_view * view);

int etpan_folder_view_is_searching(struct etpan_folder_view * view);
int etpan_folder_view_is_indexing(struct etpan_folder_view * view);
int etpan_folder_view_is_indexing_body(struct etpan_folder_view * view);

#endif
