#ifndef ETPAN_FOLDER_H

#define ETPAN_FOLDER_H

#include "etpan-folder-types.h"

#include <libetpan/libetpan.h>

#include "etpan-message-types.h"
#include "etpan-storage-types.h"
#include "etpan-thread-manager-app-types.h"

/* init */

struct etpan_folder * etpan_folder_new(void);

void etpan_folder_ref(struct etpan_folder * folder);
void etpan_folder_unref(struct etpan_folder * folder);

/* setup */

void etpan_folder_set_data(struct etpan_folder * folder,
    void * data);

void * etpan_folder_get_data(struct etpan_folder * folder);

void etpan_folder_set_driver(struct etpan_folder * folder,
    struct etpan_folder_driver * driver);

struct etpan_folder_driver *
etpan_folder_get_driver(struct etpan_folder * folder);

void etpan_folder_set_storage(struct etpan_folder * folder,
    struct etpan_storage * storage);

void etpan_folder_set_location(struct etpan_folder * folder, char * location);

void etpan_folder_set_default_recipient(struct etpan_folder * folder,
    char * default_recipient);

void etpan_folder_set_max(struct etpan_folder * folder,
    unsigned int max);

void etpan_folder_set_special_folder(struct etpan_folder * folder,
    char * name, struct etpan_folder * special_folder);

void etpan_folder_set_special_folder_by_location(struct etpan_folder * folder,
    char * name, char * location);

void etpan_folder_set_draft_by_location(struct etpan_folder * folder,
    char * draft);

void etpan_folder_set_sent_by_location(struct etpan_folder * folder,
    char * sent);

void etpan_folder_set_trash_by_location(struct etpan_folder * folder,
    char * trash);

void etpan_folder_set_draft(struct etpan_folder * folder,
    struct etpan_folder * draft);

void etpan_folder_set_sent(struct etpan_folder * folder,
    struct etpan_folder * sent);

void etpan_folder_set_trash(struct etpan_folder * folder,
    struct etpan_folder * trash);

void etpan_folder_set_ui_path(struct etpan_folder * folder,
    char * ui_path);

void etpan_folder_set_poll(struct etpan_folder * folder,
    int poll);

void etpan_folder_set_count(struct etpan_folder * folder,
    unsigned int total,
    unsigned int unseen,
    unsigned int recent);

void etpan_folder_clear_count(struct etpan_folder * folder);

void etpan_folder_set_lost(struct etpan_folder * folder,
    int lost);

void etpan_folder_set_uid(struct etpan_folder * folder, char * uid);

char * etpan_folder_get_uid(struct etpan_folder * folder);

void etpan_folder_set_show_unfiltered(struct etpan_folder * folder, int value);

int etpan_folder_get_show_unfiltered(struct etpan_folder * folder);

/* get info */

struct etpan_storage * etpan_folder_get_storage(struct etpan_folder * folder);

char * etpan_folder_get_location(struct etpan_folder * folder);

char * etpan_folder_get_default_recipient(struct etpan_folder * folder);

unsigned int etpan_folder_get_max(struct etpan_folder * folder);

struct etpan_folder *
etpan_folder_get_special_folder(struct etpan_folder * folder,
    char * name);

char * etpan_folder_get_special_folder_location(struct etpan_folder * folder,
    char * name);

char * etpan_folder_get_draft_location(struct etpan_folder * folder);

char * etpan_folder_get_sent_location(struct etpan_folder * folder);

char * etpan_folder_get_trash_location(struct etpan_folder * folder);

struct etpan_folder * etpan_folder_get_draft(struct etpan_folder * folder);

struct etpan_folder * etpan_folder_get_sent(struct etpan_folder * folder);

struct etpan_folder * etpan_folder_get_trash(struct etpan_folder * folder);

char * etpan_folder_get_ui_path(struct etpan_folder * folder);

char * etpan_folder_get_ui_name(struct etpan_folder * folder);

int etpan_folder_get_poll(struct etpan_folder * folder);

int etpan_folder_get_count(struct etpan_folder * folder,
    unsigned int * p_total,
    unsigned int * p_unseen,
    unsigned int * p_recent);

int etpan_folder_is_lost(struct etpan_folder * folder);

struct etpan_message *
etpan_folder_get_message(struct etpan_folder * folder, char * uid);

chash *
etpan_folder_get_message_hash(struct etpan_folder * folder);

/* network access */

struct etpan_thread_op *
etpan_folder_fetch_msg_list(struct etpan_thread_manager_app * manager,
    struct etpan_folder * folder,
    void (* callback)(int, struct etpan_folder_fetch_msg_list_result *,
        void *),
    void * cb_data);

void etpan_folder_update_msg_list(struct etpan_folder * folder,
    chash * current_message_list);

void etpan_folder_remove_lost_messages(struct etpan_folder * folder);

#if 0
void etpan_folder_clear_msg_list(struct etpan_folder * folder);
#endif

void etpan_folder_remove_msg(struct etpan_folder * folder,
    struct etpan_message * msg);

int etpan_folder_has_message_list(struct etpan_folder * folder);

struct etpan_thread_op *
etpan_folder_check(struct etpan_thread_manager_app * manager,
    struct etpan_folder * folder,
    void (* callback)(int, struct etpan_folder_check_result *, void *),
    void * cb_data);

struct etpan_thread_op *
etpan_folder_status(struct etpan_thread_manager_app * manager,
    struct etpan_folder * folder,
    void (* callback)(int, struct etpan_folder_status_result *,
        void *), void * cb_data);

struct etpan_thread_op *
etpan_folder_expunge(struct etpan_thread_manager_app * manager,
    struct etpan_folder * folder,
    void (* callback)(int, struct etpan_folder_expunge_result *, void *),
    void * cb_data);

struct etpan_thread_op *
etpan_folder_append(struct etpan_thread_manager_app * manager,
    struct etpan_folder * folder,
    char * message, size_t length,
    struct etpan_message_flags * flags,
    void (* callback)(int, struct etpan_folder_append_msg_result *, void *),
    void * cb_data);

struct etpan_thread_op *
etpan_folder_append_file(struct etpan_thread_manager_app * manager,
    struct etpan_folder * folder,
    char * filename,
    struct etpan_message_flags * flags,
    void (* callback)(int, struct etpan_folder_append_msg_result *, void *),
    void * cb_data);

struct etpan_thread_op *
etpan_folder_check_msg_list(struct etpan_thread_manager_app * manager,
    struct etpan_folder * folder,
    chash * message_list,
    void (* callback)(int, struct etpan_folder_check_msg_list_result *, void *),
    void * cb_data);

struct etpan_error * etpan_folder_setup(struct etpan_folder * folder) WARN_UNUSED_RESULT;

char * etpan_folder_get_threaded_location(struct etpan_folder * folder);

int etpan_folder_is_sub_folder(struct etpan_folder * parent,
    struct etpan_folder * child);

void etpan_folder_ref_msg_list(struct etpan_folder * folder);

void etpan_folder_unref_msg_list(struct etpan_folder * folder);

/* debug */

void etpan_folder_print_stats(void);

#endif
