#ifndef ETPAN_GLOBAL_CONFIG_H

#define ETPAN_GLOBAL_CONFIG_H

#include "etpan-global-config-types.h"
#include "etpan-error-types.h"

void etpan_global_config_set_default(struct etpan_global_config * config);
struct etpan_global_config * etpan_global_config_get_default(void);

struct etpan_error *
etpan_global_config_read(struct etpan_global_config * config,
    char * filename) WARN_UNUSED_RESULT;

struct etpan_error * etpan_global_config_read_default(void) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_global_config_save(struct etpan_global_config * config,
    char * filename) WARN_UNUSED_RESULT;

struct etpan_error * etpan_global_config_save_default(void) WARN_UNUSED_RESULT;

struct etpan_global_config * etpan_global_config_new(void);

void etpan_global_config_free(struct etpan_global_config * config);

void etpan_global_config_set_attachment_folder(struct etpan_global_config * config,
    char * attachment_folder);
char * etpan_global_config_get_attachment_folder(struct etpan_global_config * config);

#endif
