#ifndef ETPAN_INDEXER_H

#define ETPAN_INDEXER_H

#include "etpan-indexer-types.h"
#include <libetpan/libetpan.h>

#ifdef __cplusplus
extern "C" {
#endif

struct etpan_indexer * etpan_indexer_new(const char * filename);
#if 0
void etpan_indexer_free(struct etpan_indexer * indexer);
#endif

void etpan_indexer_ref(struct etpan_indexer * indexer);
void etpan_indexer_unref(struct etpan_indexer * indexer);

void etpan_indexer_clear(struct etpan_indexer * indexer);

void etpan_indexer_lock(struct etpan_indexer * indexer);
void etpan_indexer_unlock(struct etpan_indexer * indexer);

void etpan_indexer_set(struct etpan_indexer * indexer,
    char * doc_id, char * type, char * text);
void etpan_indexer_delete(struct etpan_indexer * indexer,
    char * doc_id);

carray * etpan_indexer_get_keys(struct etpan_indexer * indexer);

void etpan_indexer_flush(struct etpan_indexer * indexer);

carray * etpan_indexer_search(struct etpan_indexer * indexer, char * expr);

void etpan_indexer_free_search_result(carray * search_result);

char * etpan_indexer_quote(char * str);

void etpan_indexer_set_max_response_count(unsigned int count);

#ifdef __cplusplus
}
#endif

#endif
