#ifndef ETPAN_LEP_H

#define ETPAN_LEP_H

#include <libetpan/libetpan.h>
#include "etpan-folder-types.h"
#include "etpan-message-types.h"
#include "etpan-message-header-types.h"
#include "etpan-part-header-types.h"

struct etpan_error * etpan_lep_fetch_msg_list(struct etpan_folder * folder,
    struct mailfolder * ep_folder,
    chash * current_msg_list) WARN_UNUSED_RESULT;

struct etpan_error * etpan_lep_engine_setup(void) WARN_UNUSED_RESULT;
void etpan_lep_engine_unsetup(void);

struct mailprivacy * etpan_lep_privacy(void);

struct mail_flags *
etpan_lep_flags_to_lep(struct etpan_message_flags * flags);

struct etpan_message_flags *
etpan_lep_flags_from_lep(struct mail_flags * lep_flags);

struct etpan_address * etpan_lep_address_from_lep(struct mailimf_mailbox * mb);
struct mailimf_mailbox * etpan_lep_address_to_lep(struct etpan_address * addr);

struct mailimf_mailbox_list *
etpan_lep_address_list_to_lep_mb(carray * addr_list);
struct mailimf_address_list *
etpan_lep_address_list_to_lep_addr(carray * addr_list);

carray * etpan_lep_address_list_from_lep_mb(struct mailimf_mailbox_list *
    lep_mb_list);
carray * etpan_lep_address_list_from_lep_addr(struct mailimf_address_list *
    lep_addr_list);

struct etpan_error * etpan_fetch_bodystructure(mailmessage * ep_msg) WARN_UNUSED_RESULT;
void etpan_flush_bodystructure(mailmessage * ep_msg);

char * etpan_encode_mime_header(char * phrase);
char * etpan_decode_mime_header(char * phrase);

char * etpan_get_content_type_str(struct mailmime_content * content);

struct etpan_message_header *
etpan_header_from_lep_header(struct mailimf_fields * fields);

struct mailimf_fields *
etpan_header_to_lep_header(struct etpan_message_header * header);

void etpan_append_mailbox_list(struct mailimf_mailbox_list * new_mb_list,
    struct mailimf_mailbox_list * mb_list);

void
etpan_single_resent_fields_init(struct mailimf_single_fields * single_fields,
    struct mailimf_fields * fields);

struct mailimf_mailbox_list *
etpan_address_to_mailbox_list(struct mailimf_address_list * addr_list);

struct mailfolder * etpan_lep_folder_from_folder(struct etpan_folder * folder);
void etpan_set_lep_folder(struct etpan_folder * folder,
    struct mailfolder * lep_folder);

carray * etpan_address_list_to_from_str(char * str);

struct etpan_part_header *
etpan_mime_header_from_lep(struct mailmime_fields * mime_fields,
    struct mailmime_content * mime_content);

#endif
