#ifndef ETPAN_LOG_H

#define ETPAN_LOG_H

#define ENABLE_LOG

#ifdef __cplusplus
extern "C" {
#endif

/*
  an environment variable ETPAN_LOG must be set
  and will contains the log identifier separated with spaces.
*/

#ifdef ENABLE_LOG

#ifndef ETPAN_MODULE_LOG_NAME
#define ETPAN_MODULE_LOG_NAME "LOG"
#endif

#ifndef __LINE__
#define __LINE__ 0
#endif

#define ETPAN_FOLDER_INDEXER_LOG(...) ETPAN_LOG_ID("FOLDERINDEXER", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_GTK_TREE_MODEL_LOG(...) ETPAN_LOG_ID("GTKTREEMODEL", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_TABBED_LOG(...) ETPAN_LOG_ID("TABBED", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_MSGVIEW_LOG(...) ETPAN_LOG_ID("MSGVIEW", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_MSGLIST_LOG(...) ETPAN_LOG_ID("MSGLIST", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_FOLDERLIST_LOG(...) ETPAN_LOG_ID("FOLDERLIST", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_MAINWINDOW_LOG(...) ETPAN_LOG_ID("MAINWINDOW", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_UI_LOG(...) ETPAN_LOG_ID("UI", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_STATUS_BAR_LOG(...) ETPAN_LOG_ID("STATUSBAR", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_STACK_LOG(...) ETPAN_LOG_ID("STACK", __FILE__, __LINE__ , __VA_ARGS__)

#define ETPAN_WARN_LOG(...) ETPAN_LOG_ID("WARNING", __FILE__, __LINE__ , __VA_ARGS__)
#define ETPAN_LOCAL_LOG(...) ETPAN_LOG_ID(ETPAN_MODULE_LOG_NAME, __FILE__, __LINE__ , __VA_ARGS__)

#define ETPAN_LOG(...) ETPAN_LOG_ID("LOG", __FILE__, __LINE__ , __VA_ARGS__)

#define ETPAN_ASSERT(cond, ...) do { if (!(cond)) ETPAN_CRASH(__VA_ARGS__); } while (0)

#else /* !ENABLE_LOG */

#define ETPAN_FOLDER_INDEXER_LOG(...)
#define ETPAN_GTK_TREE_MODEL_LOG(...)
#define ETPAN_TABBED_LOG(...)
#define ETPAN_MSGVIEW_LOG(...)
#define ETPAN_MSGLIST_LOG(...)
#define ETPAN_FOLDERLIST_LOG(...)
#define ETPAN_MAINWINDOW_LOG(...)
#define ETPAN_UI_LOG(...)
#define ETPAN_STATUS_BAR_LOG(...)
#define ETPAN_STACK_LOG(...)

#define ETPAN_WARN_LOG(...)
#ifdef ETPAN_MODULE_LOG_NAME
#define ETPAN_LOCAL_LOG(...)
#else
#define ETPAN_LOCAL_LOG(...) ETPAN_LOG_ID("LOG", __FILE__, __LINE__, __VA_ARGS__)
#endif

#define ETPAN_LOG(...) ETPAN_LOG_ID("LOG", __FILE__, __LINE__, __VA_ARGS__)

#define ETPAN_ASSERT(...)

#endif /* ENABLE_LOG */

#define ETPAN_LOG_MEMORY_ERROR \
    do { \
      ETPAN_WARN_LOG("failure because of lack of memory"); \
      etpan_crash(); \
    } \
    while (0)

#define ETPAN_CRASH(...) \
    do { \
      ETPAN_WARN_LOG(__VA_ARGS__); \
      etpan_crash(); \
    } \
    while (0)

#define ETPAN_LOG_ID(...) etpan_log(__VA_ARGS__)

void etpan_log_init(void);
void etpan_log_done(void);
void etpan_log(char * log_id, char * filename, unsigned int line_number,
    char * format, ...);

void etpan_log_stack(void);

void etpan_crash(void);
void etpan_crash_report_setup(void);
void etpan_crash_report_unsetup(void);

extern void (* etpan_log_callback)(const char * str);

#ifdef __cplusplus
}
#endif

#endif
