#ifndef ETPAN_MAIL_MANAGER_H

#define ETPAN_MAIL_MANAGER_H

#include <libetpan/libetpan.h>

#include "etpan-mail-manager-types.h"
#include "etpan-folder-types.h"
#include "etpan-folder-indexer-types.h"

struct etpan_mail_manager * etpan_mail_manager_new(void);
void etpan_mail_manager_free(struct etpan_mail_manager * manager);

void etpan_mail_manager_set_default(struct etpan_mail_manager * manager);
struct etpan_mail_manager * etpan_mail_manager_get_default(void);

void etpan_mail_manager_setup(struct etpan_mail_manager * manager);
void etpan_mail_manager_stop(struct etpan_mail_manager * manager,
    void (* callback)(void *), void * user_data);
void etpan_mail_manager_unsetup(struct etpan_mail_manager * manager);

/* run task */
double etpan_mail_manager_next_task_date(struct etpan_mail_manager * manager);
void etpan_mail_manager_perform_next_task(struct etpan_mail_manager * manager);

/* storage operations */
void etpan_mail_manager_storage_update(struct etpan_mail_manager * manager,
    struct etpan_storage * storage);
void etpan_mail_manager_remove_storage(struct etpan_mail_manager * manager,
    struct etpan_storage * storage);
struct etpan_error *
etpan_mail_manager_storage_get_error(struct etpan_mail_manager * manager,
    struct etpan_storage * storage);
struct etpan_storage_folder_order *
etpan_mail_manager_storage_get_order(struct etpan_mail_manager * manager,
    struct etpan_storage * storage);

/* folder operations */
void etpan_mail_manager_folder_open(struct etpan_mail_manager * manager,
    struct etpan_folder * folder);
void etpan_mail_manager_folder_close(struct etpan_mail_manager * manager,
    struct etpan_folder * folder);
struct etpan_folder_indexer * etpan_mail_manager_get_indexer(struct etpan_mail_manager * manager, struct etpan_folder * folder);
void etpan_mail_manager_folder_check(struct etpan_mail_manager * manager,
    struct etpan_folder * folder);
void etpan_mail_manager_folder_update(struct etpan_mail_manager * manager,
    struct etpan_folder * folder);
struct etpan_error *
etpan_mail_manager_folder_get_error(struct etpan_mail_manager * manager,
    struct etpan_folder * folder);
int etpan_mail_manager_folder_has_count(struct etpan_mail_manager * manager,
    struct etpan_folder * folder);
unsigned int etpan_mail_manager_folder_get_total_count(struct etpan_mail_manager * manager,
    struct etpan_folder * folder);
unsigned int etpan_mail_manager_folder_get_unread_count(struct etpan_mail_manager * manager,
    struct etpan_folder * folder);

#if 0
void etpan_mail_manager_folder_append_message(struct etpan_mail_manager * manager,
    struct etpan_folder * folder, struct etpan_message * msg);
void etpan_mail_manager_folder_append_content(struct etpan_mail_manager * manager,
    struct etpan_folder * folder, char * message, size_t length);
#endif

unsigned int etpan_mail_manager_get_next_copy_messages_id(struct etpan_mail_manager * manager);
void etpan_mail_manager_copy_messages(struct etpan_mail_manager * manager,
    struct etpan_folder * folder, chash * msg_hash);
void etpan_mail_manager_move_messages(struct etpan_mail_manager * manager,
    struct etpan_folder * folder, chash * msg_hash);
struct etpan_error * etpan_mail_manager_copy_messages_get_error(struct etpan_mail_manager * manager);

unsigned int etpan_mail_manager_get_next_delete_messages_id(struct etpan_mail_manager * manager);
void etpan_mail_manager_delete_messages(struct etpan_mail_manager * manager,
    chash * msg_hash);
struct etpan_error * etpan_mail_manager_delete_messages_get_error(struct etpan_mail_manager * manager);

unsigned int etpan_mail_manager_get_next_copy_folder_id(struct etpan_mail_manager * manager);
void etpan_mail_manager_copy_folder(struct etpan_mail_manager * manager,
    struct etpan_storage * dest_storage,
    struct etpan_folder * dest_folder,
    struct etpan_folder * source_folder);
void etpan_mail_manager_move_folder(struct etpan_mail_manager * manager,
    struct etpan_storage * dest_storage,
    struct etpan_folder * dest_folder,
    struct etpan_folder * source_folder);
struct etpan_error * etpan_mail_manager_copy_folder_get_error(struct etpan_mail_manager * manager);

chash * etpan_mail_manager_get_pending_added_messages(struct etpan_mail_manager * manager, struct etpan_folder * folder);
chash * etpan_mail_manager_get_pending_deleted_messages(struct etpan_mail_manager * manager);

int etpan_mail_manager_operation_is_allowed(struct etpan_mail_manager * manager,
    struct etpan_folder * folder);

#endif
