#ifndef ETPAN_MESSAGE_ARCHIVE_H

#define ETPAN_MESSAGE_ARCHIVE_H

#include "etpan-message-archive-types.h"
#include "etpan-error-types.h"

struct etpan_message_archive * etpan_message_archive_new(void);

void etpan_message_archive_ref(struct etpan_message_archive * msg_archive);
void etpan_message_archive_unref(struct etpan_message_archive * msg_archive);

void etpan_message_archive_set_msglist(struct etpan_message_archive * msg_archive,
    chash * msglist);

void etpan_message_archive_setup(struct etpan_message_archive * msg_archive);

void etpan_message_archive_run(struct etpan_message_archive * msg_archive);
void etpan_message_archive_cancel(struct etpan_message_archive * msg_archive);

struct etpan_error *
etpan_message_archive_get_error(struct etpan_message_archive * msg_archive);

chash * etpan_message_archive_get_pending_for_deletion(struct etpan_message_archive * msg_archive);

#endif
