#ifndef ETPAN_MESSAGE_COLOR_H

#define ETPAN_MESSAGE_COLOR_H

#include "etpan-message-color-types.h"
#include "etpan-error-types.h"

struct etpan_message_color * etpan_message_color_get_default(void);
void etpan_message_color_set_default(struct etpan_message_color * msg_color);

struct etpan_message_color * etpan_message_color_new(void);
void etpan_message_color_free(struct etpan_message_color * msg_color);

char * etpan_message_color_get_color(struct etpan_message_color * msg_color,
    char * msgid);
void etpan_message_color_set_color(struct etpan_message_color * msg_color,
    char * msgid, char * color);

struct etpan_error *
etpan_message_color_read(struct etpan_message_color * msg_color,
    char * filename) WARN_UNUSED_RESULT;
struct etpan_error *
etpan_message_color_read_default(void) WARN_UNUSED_RESULT;

struct etpan_error *
etpan_message_color_save(struct etpan_message_color * msg_color,
    char * filename) WARN_UNUSED_RESULT;
struct etpan_error *
etpan_message_color_save_default(void) WARN_UNUSED_RESULT;

#endif
