#ifndef ETPAN_MESSAGE_COMPOSER_TYPES_H

#define ETPAN_MESSAGE_COMPOSER_TYPES_H

#include <libetpan/libetpan.h>

#include "etpan-message-header-types.h"
#include "etpan-message-fetcher-types.h"

#define ETPAN_MESSAGE_COMPOSER_READY_SIGNAL \
  "org.etpan.message-composer.ready"

enum {
  ETPAN_ATTACH_TYPE_TEXT,
  ETPAN_ATTACH_TYPE_FILE,
};

enum {
  ETPAN_REPLY_TYPE_NORMAL, /* if Reply-To, use reply to, else use From */
  ETPAN_REPLY_TYPE_LIST, /* use List-Post header */
  ETPAN_REPLY_TYPE_ALL, /* reply all */
  ETPAN_REPLY_TYPE_AUTO,
  /* if Reply-To use reply to,
     else if List-Post header is present, use reply list,
     else reply all */
};

enum {
  ETPAN_COMPOSE_TYPE_NEW,
  ETPAN_COMPOSE_TYPE_REPLY,
  ETPAN_COMPOSE_TYPE_FORWARD,
};

enum {
  ETPAN_FORWARD_TYPE_NORMAL,
  ETPAN_FORWARD_TYPE_AS_ATTACHMENT, /* not implemented */
};

struct etpan_attach_item {
  int type;
  char * text;
  size_t size;
  char * filename;
  int temporary;
};

struct etpan_message_composer {
  struct etpan_message_header * header;
  carray * attachment_list;
  int cursor;
  char * account_id;
  
  /* fetcher */
  struct etpan_message_fetcher * fetcher;
  struct etpan_error * error;
  
  int reply_type;
  int forward_type;
  
  int compose_type;
  struct etpan_message * reference_msg;
};

#endif
