#ifndef ETPAN_MESSAGE_COMPOSER_H

#define ETPAN_MESSAGE_COMPOSER_H

#include "etpan-message-composer-types.h"
#include "etpan-message-types.h"
#include "etpan-account-types.h"

struct etpan_message_composer * etpan_message_composer_new(void);
void etpan_message_composer_free(struct etpan_message_composer * composer);

void etpan_message_composer_preprend_text(struct etpan_message_composer * composer,
    char * text, int length);

void etpan_message_composer_add_text(struct etpan_message_composer * composer,
    char * text, int length);
void etpan_message_composer_add_file(struct etpan_message_composer * composer,
    char * filename, int temporary);

void etpan_message_composer_set_references(struct etpan_message_composer * composer, carray * references);

void etpan_message_composer_set_message(struct etpan_message_composer * composer, struct etpan_message * msg);

void etpan_message_composer_render(struct etpan_message_composer * composer,
    char ** result_text, size_t * result_size);

struct etpan_message_header * etpan_message_composer_get_header(struct etpan_message_composer * composer);

/* returns a list of etpan_attach_item */
carray * etpan_message_composer_get_part_list(struct etpan_message_composer * composer);

int etpan_attach_item_get_type(struct etpan_attach_item * item);

char * etpan_attach_item_file_get_name(struct etpan_attach_item * item);
int etpan_attach_item_file_is_temporary(struct etpan_attach_item * item);
void etpan_attach_item_file_set_temporary(struct etpan_attach_item * item,
    int temporary);

void etpan_attach_item_get_text_content(struct etpan_attach_item * item,
    char ** p_content, size_t * p_content_size);
void etpan_attach_item_set_text_content(struct etpan_attach_item * item,
    char * content, size_t content_size);

void etpan_message_composer_set_cursor(struct etpan_message_composer * composer, int part_index);
int etpan_message_composer_get_cursor(struct etpan_message_composer * composer);

/* message generation */
void etpan_message_composer_reply(struct etpan_message_composer * composer,
    struct etpan_message * msg, int reply_type);
void etpan_message_composer_reply_cancel(struct etpan_message_composer * composer);
struct etpan_error * etpan_message_composer_reply_get_error(struct etpan_message_composer * composer);

void etpan_message_composer_forward(struct etpan_message_composer * composer,
    struct etpan_message * msg, int forward_type);
void etpan_message_composer_forward_cancel(struct etpan_message_composer * composer);
struct etpan_error * etpan_message_composer_forward_get_error(struct etpan_message_composer * composer);

void etpan_message_composer_add_signature(struct etpan_message_composer * composer);

void etpan_message_composer_set_account(struct etpan_message_composer * composer, struct etpan_account * account);

void etpan_message_composer_set_reference_message(struct etpan_message_composer * composer, struct etpan_message * msg, int compose_type);
void etpan_message_composer_mark_done(struct etpan_message_composer * composer);

void etpan_message_composer_send(struct etpan_message_composer * composer,
    void (* callback)(struct etpan_error * error, void * cb_data),
    void * cb_data);

#endif
