#ifndef ETPAN_MESSAGE_COPY_H

#define ETPAN_MESSAGE_COPY_H

#include "etpan-message-copy-types.h"

struct etpan_message_copy * etpan_message_copy_new(void);

void etpan_message_copy_ref(struct etpan_message_copy * msg_copy);
void etpan_message_copy_unref(struct etpan_message_copy * msg_copy);

void etpan_message_copy_set_delete(struct etpan_message_copy * msg_copy,
    int delete);
int etpan_message_copy_get_delete(struct etpan_message_copy * msg_copy);

void etpan_message_copy_set_msglist(struct etpan_message_copy * msg_copy,
    chash * msglist);

void etpan_message_copy_set_destination(struct etpan_message_copy * msg_copy,
    struct etpan_folder * folder);
struct etpan_folder *
etpan_message_copy_get_destination(struct etpan_message_copy * msg_copy);

void etpan_message_copy_setup(struct etpan_message_copy * msg_copy);

void etpan_message_copy_run(struct etpan_message_copy * msg_copy);
void etpan_message_copy_cancel(struct etpan_message_copy * msg_copy);

struct etpan_error *
etpan_message_copy_get_error(struct etpan_message_copy * msg_copy);

chash * etpan_message_copy_get_pending_for_deletion(struct etpan_message_copy * msg_copy);
chash * etpan_message_copy_get_pending_for_copy(struct etpan_message_copy * msg_copy);
chash * etpan_message_copy_get_msg_copied(struct etpan_message_copy * msg_copy);
chash * etpan_message_copy_get_msg_deleted(struct etpan_message_copy * msg_copy);

#endif
