#ifndef ETPAN_MESSAGE_FETCHED_TYPES_H

#define ETPAN_MESSAGE_FETCHED_TYPES_H

#include <sys/types.h>
#include <libetpan/libetpan.h>

#include "etpan-error-types.h"

#define ETPAN_MESSAGE_FETCHER_PARTFETCHED_SIGNAL \
  "org.etpan.message-fetched.part-fetched"

#define ETPAN_MESSAGE_FETCHER_FINISHED_SIGNAL \
  "org.etpan.message-fetched.finished"

enum {
  ETPAN_MESSAGE_FETCHER_FLAGS_ATTACHMENT = 1 << 1,
  ETPAN_MESSAGE_FETCHER_FLAGS_IMAGE = 1 << 2,
  ETPAN_MESSAGE_FETCHER_FLAGS_DECODE_ATTACHMENT_CHARSET = 1 << 3,
  ETPAN_MESSAGE_FETCHER_FLAGS_SOURCE = 1 << 4,
};

struct etpan_message_fetcher {
  int ref_count;
  int flags;
  unsigned int current_part;
  carray * part_list;
  struct etpan_thread_op * part_op;
  struct etpan_message * message;
  char * temp_dir;
  struct etpan_error * error;
  int fetched;
};

enum {
  ETPAN_PART_FETCH_INFO_NONE,
  ETPAN_PART_FETCH_INFO_TYPE_TEXT,
  ETPAN_PART_FETCH_INFO_TYPE_FILE,
};

struct etpan_part_fetch_info {
  struct etpan_part * part;
  int type;
  char * content;
  size_t content_length;
  char * filename;
  int temporary;
};

#endif
