#ifndef ETPAN_MESSAGE_FETCHER_H

#define ETPAN_MESSAGE_FETCHER_H

#include "etpan-message-fetcher-types.h"
#include "etpan-error-types.h"

#include <time.h>

int etpan_message_is_header_displayed(char * name);

/* etpan_message_fetcher */
struct etpan_message_fetcher * etpan_message_fetcher_new(void);

void etpan_message_fetcher_ref(struct etpan_message_fetcher * fetcher);
void etpan_message_fetcher_unref(struct etpan_message_fetcher * fetcher);

void etpan_message_fetcher_setup(struct etpan_message_fetcher * fetcher);

void etpan_message_fetcher_set_flags(struct etpan_message_fetcher * fetcher,
    int flags);
int etpan_message_fetcher_get_flags(struct etpan_message_fetcher * fetcher);

void etpan_message_fetcher_set_message(struct etpan_message_fetcher * fetcher,
    struct etpan_message * message);
struct etpan_message * etpan_message_fetcher_get_message(struct etpan_message_fetcher * fetcher);

carray * etpan_message_fetcher_get_part_list(struct etpan_message_fetcher * fetcher);
struct etpan_error * etpan_message_fetcher_get_error(struct etpan_message_fetcher * fetcher);

void etpan_message_fetcher_run(struct etpan_message_fetcher * fetcher);
void etpan_message_fetcher_cancel(struct etpan_message_fetcher * fetcher);

/* fetch info */
int etpan_part_fetch_info_get_type(struct etpan_part_fetch_info * info);
void etpan_part_fetch_info_get_content(struct etpan_part_fetch_info * info,
    char ** p_content, size_t * p_content_length);
char * etpan_part_fetch_info_get_filename(struct etpan_part_fetch_info * info);
int etpan_part_fetch_info_is_temporary(struct etpan_part_fetch_info * info);
void etpan_part_fetch_info_set_temporary(struct etpan_part_fetch_info * info,
    int temporary);
struct etpan_part * etpan_part_fetch_info_get_part(struct etpan_part_fetch_info * info);

#endif
