#ifndef ETPAN_MESSAGE_HEADER_H

#define ETPAN_MESSAGE_HEADER_H

#include <libetpan/libetpan.h>
#include <stdlib.h>
#include <string.h>

#include "etpan-message-header-types.h"

/* TODO :
   - newsgroups should be splitted into several parts
   - mailing-list headers
*/

struct etpan_message_header * etpan_message_header_new(void);
void etpan_message_header_free(struct etpan_message_header * header);

struct etpan_message_header *
etpan_message_header_parse(char * content, size_t length);

time_t etpan_message_header_get_date(struct etpan_message_header * header);
void etpan_message_header_set_date(struct etpan_message_header * header,
    time_t date);

char * etpan_message_header_get_subject(struct etpan_message_header * header);
void etpan_message_header_set_subject(struct etpan_message_header * header,
    const char * subject);

char * etpan_message_header_get_newsgroups(struct etpan_message_header * header);
void etpan_message_header_set_newsgroups(struct etpan_message_header * header,
    const char * newsgroups);

struct etpan_address *
etpan_message_header_get_listpost(struct etpan_message_header * header);

void etpan_message_header_set_listpost(struct etpan_message_header * header,
    struct etpan_address * listpost);

/* the following are carray address list ... */
carray * etpan_message_header_get_from(struct etpan_message_header * header);
carray * etpan_message_header_get_replyto(struct etpan_message_header * header);
carray * etpan_message_header_get_to(struct etpan_message_header * header);
carray * etpan_message_header_get_cc(struct etpan_message_header * header);
carray * etpan_message_header_get_bcc(struct etpan_message_header * header);

void etpan_message_header_set_from(struct etpan_message_header * header,
    carray * from);
void etpan_message_header_set_replyto(struct etpan_message_header * header,
    carray * replyto);
void etpan_message_header_set_to(struct etpan_message_header * header,
    carray * to);
void etpan_message_header_set_cc(struct etpan_message_header * header,
    carray * cc);
void etpan_message_header_set_bcc(struct etpan_message_header * header,
    carray * bcc);

carray * etpan_message_header_get_resent_from(struct etpan_message_header * header);
carray * etpan_message_header_get_resent_to(struct etpan_message_header * header);
carray * etpan_message_header_get_resent_cc(struct etpan_message_header * header);
carray * etpan_message_header_get_resent_bcc(struct etpan_message_header * header);

void etpan_message_header_set_resent_from(struct etpan_message_header * header,
    carray * from);
void etpan_message_header_set_resent_to(struct etpan_message_header * header,
    carray * to);
void etpan_message_header_set_resent_cc(struct etpan_message_header * header,
    carray * cc);
void etpan_message_header_set_resent_bcc(struct etpan_message_header * header,
    carray * bcc);

time_t etpan_message_header_get_resent_date(struct etpan_message_header * header);
void etpan_message_header_set_resent_date(struct etpan_message_header * header,
    time_t date);

char * etpan_message_header_get_resent_msgid(struct etpan_message_header * header);
void etpan_message_header_set_resent_msgid(struct etpan_message_header * header,
    char * msgid);

/*
mailimf_resent_fields_new_with_data(struct mailimf_mailbox_list * from,
    struct mailimf_mailbox * sender,
    struct mailimf_address_list * to,
    struct mailimf_address_list * cc,
    struct mailimf_address_list * bcc);
*/

/* ... until there */

/* this is a carray of malloc'ed strings ... */
void etpan_message_header_set_references(struct etpan_message_header * header,
    carray * references);
void etpan_message_header_set_inreplyto(struct etpan_message_header * header,
    carray * inreplyto);

carray * etpan_message_header_get_references(struct etpan_message_header * header);
carray * etpan_message_header_get_inreplyto(struct etpan_message_header * header);
/* ... until there */

void etpan_message_header_set_msgid(struct etpan_message_header * header,
    char * msgid);
char * etpan_message_header_get_msgid(struct etpan_message_header * header);

/* msg id list */
carray * etpan_message_id_list_new(void);
void etpan_message_id_list_free(carray * msgid_list);

carray * etpan_message_id_list_dup(carray * msgid_list);
void etpan_message_id_list_add(carray * msgid_list, char * msgid);

/* array of etpan_unparsed_header_item */
carray * etpan_unparsed_header_new(void);
void etpan_unparsed_header_free(carray * header_list);

carray * etpan_unparsed_header_parse(char * content, size_t length);

void etpan_unparsed_header_add(carray * header_list,
    struct etpan_unparsed_header_item * item);

struct etpan_unparsed_header_item * etpan_unparsed_header_item_new(void);

void etpan_unparsed_header_item_free(struct etpan_unparsed_header_item * item);

void etpan_unparsed_header_item_set_name(struct etpan_unparsed_header_item *
    item, char * name);
char *
etpan_unparsed_header_item_get_name(struct etpan_unparsed_header_item * item);

void etpan_unparsed_header_item_set_value(struct etpan_unparsed_header_item *
    item, char * value);
char *
etpan_unparsed_header_item_get_value(struct etpan_unparsed_header_item * item);

char * etpan_unparsed_header_get_value(carray * header_list, char * name);

/* helpers */

void etpan_message_header_set_from_str(struct etpan_message_header * header,
    char * str);
void etpan_message_header_set_replyto_str(struct etpan_message_header * header,
    char * str);
void etpan_message_header_set_to_str(struct etpan_message_header * header,
    char * str);
void etpan_message_header_set_cc_str(struct etpan_message_header * header,
    char * str);
void etpan_message_header_set_bcc_str(struct etpan_message_header * header,
    char * str);

char * etpan_message_header_subject_normalize(char * subject);

void etpan_message_header_serialize(struct etpan_message_header * header,
    void ** p_data, size_t * p_length);

struct etpan_message_header *
etpan_message_header_unserialize(void * data, size_t length);

#endif
