#ifndef ETPAN_MESSAGE_TREE_LEP_H

#define ETPAN_MESSAGE_TREE_LEP_H

#include "etpan-message-tree-lep-types.h"

struct etpan_message_tree * etpan_message_tree_new(void);
void etpan_message_tree_free(struct etpan_message_tree * tree);
void etpan_message_tree_free_recursive(struct etpan_message_tree * tree);
void etpan_message_tree_set_message(struct etpan_message_tree * tree,
    struct etpan_message * msg);
void etpan_message_tree_add_child(struct etpan_message_tree * parent,
    struct etpan_message_tree * child);
carray * etpan_message_tree_get_children(struct etpan_message_tree * parent);
struct etpan_message * etpan_message_tree_get_message(struct etpan_message_tree * tree);
struct etpan_message_tree * etpan_message_tree_get_parent(struct etpan_message_tree * parent);

/* very inefficient */
void etpan_message_tree_remove_child_list(struct etpan_message_tree * root,
    chash * msg_hash);

struct etpan_message_tree * etpan_message_tree_generate(chash * msg_hash);

#endif
