#ifndef ETPAN_MESSAGE_TYPES

#define ETPAN_MESSAGE_TYPES

#include <libetpan/libetpan.h>
#include <pthread.h>

#include "etpan-part-types.h"
#include "etpan-message-header-types.h"
#include "etpan-error-types.h"

struct etpan_message;
struct etpan_message_flags;
struct etpan_part;

struct etpan_message_driver {
  char * name;
  
  struct etpan_message_header * (* get_header)(struct etpan_message * msg);
  
  struct etpan_error * (* check)(struct etpan_message * msg,
      struct etpan_message_flags * flags) WARN_UNUSED_RESULT;
  
  struct etpan_error * (* fetch_part_list)(struct etpan_message * msg,
      struct etpan_part ** p_main_part) WARN_UNUSED_RESULT;
  
  void (* clear_part_list)(struct etpan_message * msg);
  
  void (* free_data)(struct etpan_message * msg);
};

struct etpan_message {
  int ref_count;
  struct etpan_folder * folder;
  
  char * description;
  char * uid;
  int lost;
  int filtered;
  
  int part_ref;
  struct etpan_part * main_part;
  chash * part_hash;
  
  struct etpan_message_header * header;
  struct etpan_message_flags * flags;
  struct etpan_message_flags * original_flags;
  
  void * data;
  struct etpan_message_driver * driver;
  
  pthread_mutex_t lock;
};

enum {
  ETPAN_FLAGS_NEW = 1 << 0,
  ETPAN_FLAGS_SEEN = 1 << 1,
  ETPAN_FLAGS_FLAGGED = 1 << 2,
  ETPAN_FLAGS_DELETED = 1 << 3,
  ETPAN_FLAGS_ANSWERED = 1 << 4,
  ETPAN_FLAGS_FORWARDED = 1 << 5,
};

struct etpan_message_flags {
  int value;
  carray * ext;
};

struct etpan_message_fetch_part_list_result {
  struct etpan_error * error;
  struct etpan_part * part;
};

#endif
