#ifndef ETPAN_MESSAGE_H

#define ETPAN_MESSAGE_H

#include "etpan-message-types.h"
#include "etpan-thread-manager-app-types.h"

/* implementation of message must set the flags */

struct etpan_message * etpan_message_new(void);

void etpan_message_free(struct etpan_message * message);

void etpan_message_ref(struct etpan_message * message);

void etpan_message_unref(struct etpan_message * message);

void etpan_message_set_data(struct etpan_message * message, void * data);

void * etpan_message_get_data(struct etpan_message * message);

void etpan_message_set_driver(struct etpan_message * message,
    struct etpan_message_driver * driver);

void etpan_message_set_folder(struct etpan_message * message,
    struct etpan_folder * folder);

struct etpan_folder * etpan_message_get_folder(struct etpan_message * message);

void etpan_message_set_uid(struct etpan_message * message,
    char * uid);

char * etpan_message_get_uid(struct etpan_message * message);

void etpan_message_set_lost(struct etpan_message * message, int lost);

int etpan_message_is_lost(struct etpan_message * message);

int etpan_message_is_filtered(struct etpan_message * message);

void etpan_message_set_filtered(struct etpan_message * message, int value);

/* get/set flags */

void etpan_message_set_flags(struct etpan_message * message,
    struct etpan_message_flags * flags);

struct etpan_message_flags *
etpan_message_get_flags(struct etpan_message * message);

void etpan_message_set_main_part(struct etpan_message * msg,
    struct etpan_part * main_part);

struct etpan_thread_op *
etpan_message_fetch_part_list(struct etpan_thread_manager_app * manager,
    struct etpan_message * msg,
    void (* callback)(int, struct etpan_message_fetch_part_list_result *,
        void *),
    void * cb_data);

struct etpan_thread_op *
etpan_message_clear_part_list(struct etpan_thread_manager_app * manager,
    struct etpan_message * msg);

struct etpan_part *
etpan_message_get_main_part(struct etpan_message * msg);

struct etpan_part *
etpan_message_get_part(struct etpan_message * msg, char * uid);

struct etpan_message_header *
etpan_message_get_header(struct etpan_message * msg);

/* does not copy the headers */
void etpan_message_set_header(struct etpan_message * msg,
    struct etpan_message_header * header);

/* flags */

struct etpan_message_flags * etpan_message_flags_new(void);

void etpan_message_flags_free(struct etpan_message_flags * flags);

struct etpan_message_flags *
etpan_message_flags_dup(struct etpan_message_flags * flags);

void etpan_message_flags_set_value(struct etpan_message_flags * flags,
    int value);

int etpan_message_flags_get_value(struct etpan_message_flags * flags);

int etpan_message_flags_has_ext(struct etpan_message_flags * flags,
    char * ext);

void etpan_message_flags_add_ext(struct etpan_message_flags * flags,
    char * ext);

void etpan_message_flags_remove_ext(struct etpan_message_flags * flags,
    char * ext);

carray * etpan_message_flags_get_ext(struct etpan_message_flags * flags);

int etpan_message_flags_equal(struct etpan_message_flags * flags,
    struct etpan_message_flags * other);

void etpan_message_flags_serialize(struct etpan_message_flags * flags,
    void ** p_data, size_t * p_length);

struct etpan_message_flags *
etpan_message_flags_unserialize(void * data, size_t length);

/* description */

char * etpan_message_compute_description_string(struct etpan_message_header * msg_header);

void etpan_message_compute_description(struct etpan_message * msg);
char * etpan_message_get_description(struct etpan_message * msg);

char * etpan_message_get_short_date_str(time_t timestamp, time_t current_time);
char * etpan_message_get_long_date_str(time_t timestamp);

/* debug */

void etpan_message_print_stats(void);

#endif
