#ifndef ETPAN_MSG_LIST_FETCH_H

#define ETPAN_MSG_LIST_FETCH_H

#include "etpan-msg-list-fetch-types.h"

struct etpan_msg_list_fetch * etpan_msg_list_fetch_new(void);

void etpan_msg_list_fetch_ref(struct etpan_msg_list_fetch * fetcher);
void etpan_msg_list_fetch_unref(struct etpan_msg_list_fetch * fetcher);

void etpan_msg_list_fetch_setup(struct etpan_msg_list_fetch * fetcher);

void etpan_msg_list_fetch_set_folder(struct etpan_msg_list_fetch * fetcher,
    struct etpan_folder * folder);
struct etpan_folder *
etpan_msg_list_fetch_get_folder(struct etpan_msg_list_fetch * fetcher);

void etpan_msg_list_fetch_set_filter(struct etpan_msg_list_fetch * fetcher,
    struct etpan_folder_filter * filter);

void etpan_msg_list_fetch_run(struct etpan_msg_list_fetch * fetcher);
void etpan_msg_list_fetch_cancel(struct etpan_msg_list_fetch * fetcher);

struct etpan_error *
etpan_msg_list_fetch_get_error(struct etpan_msg_list_fetch * fetcher);

#endif
