#include "etpan-msg-list-iterator.h"

#include <stdlib.h>

#include "etpan-log.h"
#include "etpan-message.h"
#include "etpan-thread-manager-app.h"

struct etpan_msg_list_iterator * etpan_msg_list_iterator_new(void)
{
  struct etpan_msg_list_iterator * iterator;
  
  iterator = malloc(sizeof(* iterator));
  if (iterator == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  iterator->folder = NULL;
  iterator->current_msg_index = 0;
  iterator->msg_list = carray_new(16);
  if (iterator->msg_list == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  iterator->iterator_function = NULL;
  iterator->function_data = NULL;
  
  iterator->step_callback = NULL;
  iterator->callback = NULL;
  iterator->cb_data = NULL;
  iterator->current_msg_index = 0;
  
  return iterator;
}

static void reset_msg_list(struct etpan_msg_list_iterator * iterator);

void etpan_msg_list_iterator_free(struct etpan_msg_list_iterator * iterator)
{
  reset_msg_list(iterator);
  carray_free(iterator->msg_list);
  free(iterator);
}

static void reset_msg_list(struct etpan_msg_list_iterator * iterator)
{
  unsigned int i;
  
  for(i = 0 ; i < carray_count(iterator->msg_list) ; i ++) {
    struct etpan_message * msg;
    
    msg = carray_get(iterator->msg_list, i);
    etpan_message_unref(msg);
  }
  carray_set_size(iterator->msg_list, 0);
}

void etpan_msg_list_iterator_set_msg_list(struct etpan_msg_list_iterator * iterator, chash * msg_list)
{
  chashiter * iter;
  int r;
  
  for(iter = chash_begin(msg_list) ; iter != NULL ;
      iter = chash_next(msg_list, iter)) {
    chashdatum value;
    struct etpan_message * msg;
    
    chash_value(iter, &value);
    msg = value.data;
    etpan_message_ref(msg);
    r = carray_add(iterator->msg_list, msg, NULL);
    if (r < 0)
      ETPAN_LOG_MEMORY_ERROR;
  }
}

void etpan_msg_list_iterator_set_function(struct etpan_msg_list_iterator * iterator, void (* function)(struct etpan_message *, void *, void (* callback)(int iterate_continue, void *), void *), void * function_data)
{
  iterator->iterator_function = function;
  iterator->function_data = function_data;
}

static void run_next(struct etpan_msg_list_iterator * iterator);

void etpan_msg_list_iterator_run(struct etpan_msg_list_iterator * iterator,
    void (* step_callback)(void *),
    void (* callback)(void *), void * user_data)
{
  iterator->current_msg_index = 0;
  iterator->step_callback = step_callback;
  iterator->callback = callback;
  iterator->cb_data = user_data;
  run_next(iterator);
}

static void iterator_callback(int iterate_continue, void * data);
static void run_done(struct etpan_msg_list_iterator * iterator);

static void run_next(struct etpan_msg_list_iterator * iterator)
{
  struct etpan_message * msg;
  
  if (iterator->current_msg_index >= carray_count(iterator->msg_list)) {
    run_done(iterator);
    return;
  }
  
  msg = carray_get(iterator->msg_list, iterator->current_msg_index);
  
  iterator->iterator_function(msg, iterator->function_data,
      iterator_callback, iterator);
}

static void run_item_done(int iterate_continue,
    struct etpan_msg_list_iterator * iterator);

static void iterator_callback(int iterate_continue, void * data)
{
  struct etpan_msg_list_iterator * iterator;
  
  iterator = data;
  run_item_done(iterate_continue, iterator);
}

static void run_done(struct etpan_msg_list_iterator * iterator);

static void run_item_done(int iterate_continue,
    struct etpan_msg_list_iterator * iterator)
{
  iterator->step_callback(iterator->cb_data);
  
  if (!iterate_continue) {
    run_done(iterator);
    return;
  }
  
  iterator->current_msg_index ++;
  
  etpan_thread_manager_app_run_in_main_thread(etpan_thread_manager_app_get_default(), (void (*)(void *)) run_next, iterator, 0);
#if 0
  run_next(iterator);
#endif
}

static void run_done(struct etpan_msg_list_iterator * iterator)
{
  iterator->callback(iterator->cb_data);
}
