#ifndef ETPAN_MSG_LIST_VIEW_H

#define ETPAN_MSG_LIST_VIEW_H

#include "etpan-msg-list-view-types.h"
#include "etpan-folder-types.h"

struct etpan_msg_list_view *
etpan_msg_list_view_new(void);

void etpan_msg_list_view_free(struct etpan_msg_list_view * view);

void etpan_msg_list_view_setup(struct etpan_msg_list_view * view);
void etpan_msg_list_view_unsetup(struct etpan_msg_list_view * view);

void etpan_msg_list_view_reset(struct etpan_msg_list_view * view);

void etpan_msg_list_view_clear_messages(struct etpan_msg_list_view * view);

/* will remove lost messages */
void etpan_msg_list_view_add_messages(struct etpan_msg_list_view * view,
    chash * msg_hash);

void etpan_msg_list_view_remove_messages(struct etpan_msg_list_view * view, carray * msg_list);

/* try to avoid use of this, inefficient */
void etpan_msg_list_view_remove_folder(struct etpan_msg_list_view * view, struct etpan_folder * folder);

chash * etpan_msg_list_view_get_msg_hash(struct etpan_msg_list_view * view);

struct etpan_message_tree * etpan_msg_list_view_get_tree(struct etpan_msg_list_view * view);

void etpan_msg_list_view_update(struct etpan_msg_list_view * view);

/* on signal, read this value */
carray * etpan_msg_list_view_get_new_messages(struct etpan_msg_list_view * view);

void etpan_msg_list_view_add_folder_for_orphans(struct etpan_msg_list_view * view, struct etpan_folder * folder);
void etpan_msg_list_view_remove_folder_for_orphans(struct etpan_msg_list_view * view, struct etpan_folder * folder);

#endif
