#ifndef ETPAN_OUTBOX_TYPES_H

#define ETPAN_OUTBOX_TYPES_H

#include "etpan-storage-types.h"
#include "etpan-folder-types.h"
#include "etpan-thread-manager-types.h"
#include "etpan-error-types.h"

struct etpan_outbox {
  struct etpan_account * account;
  struct etpan_sender * sender;
  struct etpan_storage * storage;
  struct etpan_folder * folder;
  char * path;
  char * id;
  struct etpan_thread_op * current_op;
  int store;
  
  int sending;
  
  struct etpan_error * setup_error;
  volatile int setup_done;
  
  int stop_remaining;
  /* callback of end of process of outbox */
  void * process_stop_cb_data;
  void (* process_stop_callback)(struct etpan_outbox *, void *);
  /* callback of outbox_stop */
  void * stop_cb_data;
  void (* stop_callback)(struct etpan_outbox *, void *);
  
  void * process_cb_data;
  void (* process_callback)(struct etpan_outbox *, void *);
  carray * process_msg_list;
  unsigned int process_index;
  struct etpan_error * process_error;
  char * process_message_content;
  size_t process_message_length;
  struct etpan_message_fetcher * process_fetcher;
  struct etpan_folder_create * process_folder_create;
  struct etpan_msg_list_fetch * process_msg_list_fetch;
  carray * process_error_list;
  
  carray * append_op_list;
  struct etpan_error * added_error;
};

#endif
