#ifndef ETPAN_OUTBOX_H

#define ETPAN_OUTBOX_H

#include "etpan-outbox-types.h"

struct etpan_outbox * etpan_outbox_new(void);
void etpan_outbox_free(struct etpan_outbox * outbox);

void etpan_outbox_set_id(struct etpan_outbox * outbox, char * id);
char * etpan_outbox_get_id(struct etpan_outbox * outbox);

void etpan_outbox_set_path(struct etpan_outbox * outbox, char * path);
char * etpan_outbox_get_path(struct etpan_outbox * outbox);

void etpan_outbox_set_sender(struct etpan_outbox * outbox,
    struct etpan_sender * sender);
struct etpan_sender * etpan_outbox_get_sender(struct etpan_outbox * outbox);

struct etpan_error * etpan_outbox_setup(struct etpan_outbox * outbox) WARN_UNUSED_RESULT;
void etpan_outbox_unsetup(struct etpan_outbox * outbox);

void etpan_outbox_add(struct etpan_outbox * outbox,
    char * message, size_t length,
    void (* callback)(struct etpan_outbox * outbox, void * user_data),
    void * user_data);

struct etpan_error * etpan_outbox_added_get_error(struct etpan_outbox * outbox);

void etpan_outbox_process(struct etpan_outbox * outbox,
    void (* callback)(struct etpan_outbox * outbox, void * user_data),
    void * user_data);

/* must be called in the callback of process */
struct etpan_error * etpan_outbox_processed_get_error(struct etpan_outbox * outbox);

void etpan_outbox_set_account(struct etpan_outbox * outbox,
    struct etpan_account * account);
struct etpan_account * etpan_outbox_get_account(struct etpan_outbox * outbox);

void etpan_outbox_stop(struct etpan_outbox * outbox,
    void (* callback)(struct etpan_outbox * outbox, void * cb_data),
    void * cb_data);

#endif
