#include "etpan-part-header.h"

#include <stdlib.h>
#include <string.h>

#include "etpan-error.h"
#include "etpan-log.h"

struct etpan_part_header * etpan_part_header_new(void)
{
  struct etpan_part_header * header;

  header = malloc(sizeof(* header));
  if (header == NULL)
    ETPAN_LOG_MEMORY_ERROR;
  
  header->content_type = NULL;
  header->filename = NULL;
  header->mime_encoding = ETPAN_PART_MIME_ENCODING_OTHER;
  header->charset_encoding = NULL;
  
  return header;
}

void etpan_part_header_free(struct etpan_part_header * header)
{
  free(header->charset_encoding);
  free(header->filename);
  free(header->content_type);
  free(header);
}

void etpan_part_header_set_content_type(struct etpan_part_header * header,
    char * content_type)
{
  if (content_type != header->content_type) {
    free(header->content_type);
    if (content_type != NULL) {
      header->content_type = strdup(content_type);
      if (header->content_type == NULL)
        ETPAN_LOG_MEMORY_ERROR;
    }
    else
      header->content_type = NULL;
  }
}

char * etpan_part_header_get_content_type(struct etpan_part_header * header)
{
  return header->content_type;
}

void etpan_part_header_set_filename(struct etpan_part_header * header,
    char * filename)
{
  if (filename != header->filename) {
    free(header->filename);
    if (filename != NULL) {
      header->filename = strdup(filename);
      if (header->filename == NULL)
        ETPAN_LOG_MEMORY_ERROR;
    }
    else
      header->filename = NULL;
  }
}

char * etpan_part_header_get_filename(struct etpan_part_header * header)
{
  return header->filename;
}

void etpan_part_header_set_mime_encoding(struct etpan_part_header * header,
    int mime_encoding)
{
  header->mime_encoding = mime_encoding;
}

int etpan_part_header_get_mime_encoding(struct etpan_part_header * header)
{
  return header->mime_encoding;
}

void etpan_part_header_set_charset_encoding(struct etpan_part_header * header,
    char * charset_encoding)
{
  if (charset_encoding != header->charset_encoding) {
    free(header->charset_encoding);
    if (charset_encoding != NULL) {
      header->charset_encoding = strdup(charset_encoding);
      if (header->charset_encoding == NULL)
        ETPAN_LOG_MEMORY_ERROR;
    }
    else
      header->charset_encoding = NULL;
  }
}

char *
etpan_part_header_get_charset_encoding(struct etpan_part_header * header)
{
  return header->charset_encoding;
}
