#ifndef ETPAN_PART_TYPES_H

#define ETPAN_PART_TYPES_H

#include <pthread.h>
#include <libetpan/libetpan.h>

#include "etpan-message-types.h"
#include "etpan-part-header-types.h"
#include "etpan-error-types.h"

struct etpan_part;

struct etpan_part_driver {
  char * name;
  
  struct etpan_part_header * (* get_header)(struct etpan_part * part);
  
  struct etpan_error * (* fetch)(struct etpan_part * part,
      char ** p_content, size_t * p_length) WARN_UNUSED_RESULT;
  struct etpan_error * (* fetch_header)(struct etpan_part * part,
      char ** p_content, size_t * p_length) WARN_UNUSED_RESULT;
  struct etpan_error * (* fetch_mime_header)(struct etpan_part * part,
      char ** p_content, size_t * p_length) WARN_UNUSED_RESULT;
  
  void (* free_data)(struct etpan_part * part);
};

enum {
  ETPAN_PART_TYPE_MESSAGE,
  ETPAN_PART_TYPE_MULTIPLE,
  ETPAN_PART_TYPE_SINGLE,
};

struct etpan_part {
  int ref_count;
  struct etpan_message * message;
  struct etpan_part_header * header;
  
  int type;
  
  char * uid;
  carray * children;
  
  void * data;
  struct etpan_part_driver * driver;
  
  pthread_mutex_t lock;
};

struct etpan_part_fetch_result {
  struct etpan_error * error;
  char * content;
  size_t length;
};

#endif
