#ifndef ETPAN_PART_H

#define ETPAN_PART_H

#include "etpan-part-types.h"
#include "etpan-thread-manager-app-types.h"
#include "etpan-error-types.h"

struct etpan_part * etpan_part_new(void);

void etpan_part_ref(struct etpan_part * part);
void etpan_part_unref(struct etpan_part * part);

void etpan_part_set_type(struct etpan_part * part, int type);

int etpan_part_get_type(struct etpan_part * part);

struct etpan_part * etpan_part_new_single(void);

struct etpan_part * etpan_part_new_multiple(void);

struct etpan_part * etpan_part_new_message(void);
void etpan_part_free(struct etpan_part * part);

void etpan_part_set_data(struct etpan_part * part, void * data);

void * etpan_part_get_data(struct etpan_part * part);

void etpan_part_set_driver(struct etpan_part * part,
    struct etpan_part_driver * driver);

void etpan_part_set_message(struct etpan_part * part,
    struct etpan_message * message);

struct etpan_message * etpan_part_get_message(struct etpan_part * part);

struct etpan_part_header * etpan_part_get_header(struct etpan_part * part);

/* does not copy the headers */
void etpan_part_set_header(struct etpan_part * part,
    struct etpan_part_header * header);

carray * etpan_part_get_children(struct etpan_part * part);

void etpan_part_add_child(struct etpan_part * parent,
    struct etpan_part * child);

char * etpan_part_get_uid(struct etpan_part * part);

void etpan_part_set_uid(struct etpan_part * part, char * uid);

struct etpan_thread_op *
etpan_part_fetch(struct etpan_thread_manager_app * manager,
    struct etpan_part * part,
    void (* callback)(int, struct etpan_part_fetch_result *,
        void *),
    void * cb_data);

struct etpan_thread_op *
etpan_part_fetch_header(struct etpan_thread_manager_app * manager,
    struct etpan_part * part,
    void (* callback)(int, struct etpan_part_fetch_result *,
        void *),
    void * cb_data);

struct etpan_thread_op *
etpan_part_fetch_mime_header(struct etpan_thread_manager_app * manager,
    struct etpan_part * part,
    void (* callback)(int, struct etpan_part_fetch_result *,
        void *),
    void * cb_data);

struct etpan_error *
etpan_mime_decode(char * text, size_t text_length, int encoding,
    char ** result_text, size_t * result_text_length) WARN_UNUSED_RESULT;

#endif
