#ifndef ETPAN_SENDER_TYPES_H

#define ETPAN_SENDER_TYPES_H

#include "etpan-account-types.h"

struct etpan_sender;

struct etpan_sender_driver {
  char * name;
  struct etpan_error * (* connect)(struct etpan_sender *);
  void (* disconnect)(struct etpan_sender *);
  struct etpan_error * (* setup)(struct etpan_sender *);
  struct etpan_error * (* send_message)(struct etpan_sender *, char *, size_t);
  void (* free_data)(struct etpan_sender *);
};

struct etpan_sender {
  int ref_count;
  struct etpan_account * account;
  
  char * id;
  struct etpan_sender_driver * driver;
  void * data;
};

/*
  for SMTP, data :
  int connection_type;
  int auth_type;
  char * username;
  char * password;
*/

struct etpan_sender_send_message_result {
  struct etpan_error * error;
};

#endif
