#ifndef ETPAN_SENDER_H

#define ETPAN_SENDER_H

#include "etpan-sender-types.h"
#include "etpan-thread-manager-app-types.h"

struct etpan_sender * etpan_sender_new(void);

void etpan_sender_free(struct etpan_sender * sender);

void etpan_sender_set_id(struct etpan_sender * sender, char * id);
char * etpan_sender_get_id(struct etpan_sender * sender);

void etpan_sender_set_account(struct etpan_sender * sender,
    struct etpan_account * account);
struct etpan_account * etpan_sender_get_account(struct etpan_sender * sender);

struct etpan_error *
etpan_sender_setup(struct etpan_sender * sender) WARN_UNUSED_RESULT;
void etpan_sender_unsetup(struct etpan_sender * sender);

void etpan_sender_set_data(struct etpan_sender * sender, void * data);
void * etpan_sender_get_data(struct etpan_sender * sender);

void etpan_sender_set_driver(struct etpan_sender * sender,
    struct etpan_sender_driver * driver);
struct etpan_sender_driver *
etpan_sender_get_driver(struct etpan_sender * sender);

struct etpan_thread_op *
etpan_sender_send_message(struct etpan_thread_manager_app * manager,
    struct etpan_sender * sender, char * message, size_t size,
    void (* callback)(int, struct etpan_sender_send_message_result *,
        void *),
    void * cb_data);

struct etpan_thread_op *
etpan_sender_disconnect(struct etpan_thread_manager_app * manager,
    struct etpan_sender * sender,
    void (* callback)(int, void * /* dummy argument */,
        void *),
    void * cb_data);

#endif
