#ifndef ETPAN_SERIALIZE_TYPES_H

#define ETPAN_SERIALIZE_TYPES_H

#include <inttypes.h>
#include <libetpan/libetpan.h>

enum {
  ETPAN_SERIALIZE_INT32,
  ETPAN_SERIALIZE_INT64,
  ETPAN_SERIALIZE_UINT32,
  ETPAN_SERIALIZE_UINT64,
  ETPAN_SERIALIZE_STRING,
  ETPAN_SERIALIZE_ARRAY,
  ETPAN_SERIALIZE_HASH,
};

struct etpan_serialize_data {
  int type;
  union {
    int32_t data_int32;
    int64_t data_int64;
    uint32_t data_uint32;
    uint64_t data_uint64;
    struct {
      char * value;
      size_t length;
    } data_str;
    carray * data_array;
    chash * data_hash;
  } data;
};

#endif
