#ifndef ETPAN_SERIALIZE_H

#define ETPAN_SERIALIZE_H

#include "etpan-serialize-types.h"
#include <inttypes.h>

void etpan_serialize_encode(struct etpan_serialize_data * sdata,
    void ** p_data, size_t * p_length);
struct etpan_serialize_data * etpan_serialize_decode(void * data, size_t size);

void etpan_serialize_hash_set(struct etpan_serialize_data * data,
    char * key, struct etpan_serialize_data * item);
void etpan_serialize_hash_set_int32(struct etpan_serialize_data * data,
    char * key, int32_t value);
void etpan_serialize_hash_set_int64(struct etpan_serialize_data * data,
    char * key, int64_t value);
void etpan_serialize_hash_set_uint32(struct etpan_serialize_data * data,
    char * key, uint32_t value);
void etpan_serialize_hash_set_uint64(struct etpan_serialize_data * data,
    char * key, uint64_t value);
void etpan_serialize_hash_set_str(struct etpan_serialize_data * data,
    char * key, char * value);
void etpan_serialize_hash_set_sized_str(struct etpan_serialize_data * data,
    char * key, char * value, size_t length);

void etpan_serialize_array_add(struct etpan_serialize_data * data,
    struct etpan_serialize_data * item);
void etpan_serialize_array_add_int32(struct etpan_serialize_data * data,
    int32_t value);
void etpan_serialize_array_add_int64(struct etpan_serialize_data * data,
    int64_t value);
void etpan_serialize_array_add_uint32(struct etpan_serialize_data * data,
    uint32_t value);
void etpan_serialize_array_add_uint64(struct etpan_serialize_data * data,
    uint64_t value);
void etpan_serialize_array_add_str(struct etpan_serialize_data * data,
    char * value);
void etpan_serialize_array_add_sized_str(struct etpan_serialize_data * data,
    char * value, size_t length);

struct etpan_serialize_data * etpan_serialize_data_new_int32(int32_t value);
struct etpan_serialize_data * etpan_serialize_data_new_int64(int64_t value);
struct etpan_serialize_data * etpan_serialize_data_new_uint32(uint32_t value);
struct etpan_serialize_data * etpan_serialize_data_new_uint64(uint64_t value);
struct etpan_serialize_data * etpan_serialize_data_new_str(char * value);
struct etpan_serialize_data * etpan_serialize_data_new_sized_str(char * value,
    size_t length);
struct etpan_serialize_data * etpan_serialize_data_new_array(void);
struct etpan_serialize_data * etpan_serialize_data_new_hash(void);

int32_t etpan_serialize_data_get_int32(struct etpan_serialize_data * data);
int64_t etpan_serialize_data_get_int64(struct etpan_serialize_data * data);
uint32_t etpan_serialize_data_get_uint32(struct etpan_serialize_data * data);
uint64_t etpan_serialize_data_get_uint64(struct etpan_serialize_data * data);
char * etpan_serialize_data_get_str(struct etpan_serialize_data * data);
size_t etpan_serialize_data_get_str_length(struct etpan_serialize_data * data);
void etpan_serialize_data_get_sized_str(struct etpan_serialize_data * data,
    char ** p_value, size_t * p_length);
struct etpan_serialize_data *
etpan_serialize_array_get(struct etpan_serialize_data * data, unsigned int i);
struct etpan_serialize_data *
etpan_serialize_hash_get(struct etpan_serialize_data * data, char * key);

int32_t etpan_serialize_hash_get_int32(struct etpan_serialize_data * data,
    char * key);
int64_t etpan_serialize_hash_get_int64(struct etpan_serialize_data * data,
    char * key);
uint32_t etpan_serialize_hash_get_uint32(struct etpan_serialize_data * data,
    char * key);
uint64_t etpan_serialize_hash_get_uint64(struct etpan_serialize_data * data,
    char * key);
char * etpan_serialize_hash_get_str(struct etpan_serialize_data * data,
    char * key);
void etpan_serialize_hash_get_sized_str(struct etpan_serialize_data * data,
    char * key, char ** p_value, size_t * p_length);

unsigned int etpan_serialize_array_count(struct etpan_serialize_data * data);
int32_t etpan_serialize_array_get_int32(struct etpan_serialize_data * data,
    unsigned int i);
int64_t etpan_serialize_array_get_int64(struct etpan_serialize_data * data,
    unsigned int i);
uint32_t etpan_serialize_array_get_uint32(struct etpan_serialize_data * data,
    unsigned int i);
uint64_t etpan_serialize_array_get_uint64(struct etpan_serialize_data * data,
    unsigned int i);
char * etpan_serialize_array_get_str(struct etpan_serialize_data * data,
    unsigned int i);
void etpan_serialize_array_get_sized_str(struct etpan_serialize_data * data,
    unsigned int i, char ** p_value, size_t * p_length);

struct etpan_serialize_data *
etpan_serialize_data_dup(struct etpan_serialize_data * data);

void etpan_serialize_data_free(struct etpan_serialize_data * data);

int etpan_serialize_data_get_type(struct etpan_serialize_data * data);

#endif
