#ifndef ETPAN_SIGNAL_TYPES_H

#define ETPAN_SIGNAL_TYPES_H

#include <libetpan/libetpan.h>

struct etpan_signal_handler
{
  void * user_data;
  
  void (* callback)(char * signal_name, void * sender, void * signal_data,
      void * user_data);
};

struct etpan_signal_handler_list {
  chash * data_hash; /* &p => carray of etpan_signal_handler */
};

struct etpan_signal_manager {
  chash * signal_hash; /* signal_name => etpan_signal_handler_list */
};

#define ETPAN_SIGNAL_SEND(sender, name) \
  etpan_signal_send(etpan_signal_manager_get_default(), \
    name, sender, NULL)

#define ETPAN_SIGNAL_SEND_WITH_DATA(sender, name, signal_data) \
  etpan_signal_send(etpan_signal_manager_get_default(), \
    name, sender, signal_data)

#define ETPAN_SIGNAL_ADD_HANDLER(sender, name, handler, data) \
  etpan_signal_add_handler(etpan_signal_manager_get_default(), \
    name, sender, data, handler)

#define ETPAN_SIGNAL_REMOVE_HANDLER(sender, name, handler, data) \
  etpan_signal_remove_handler(etpan_signal_manager_get_default(), \
    name, sender, data, handler)

#endif
