#ifndef ETPAN_SIGNAL_H

#define ETPAN_SIGNAL_H

#include "etpan-signal-types.h"

struct etpan_signal_manager * etpan_signal_manager_new(void);
void etpan_signal_manager_free(struct etpan_signal_manager * manager);

void etpan_signal_add_handler(struct etpan_signal_manager * manager,
    char * signal_name, void * sender, void * user_data,
    void (* signal_handler)(char * signal_name, void * sender,
        void * signal_data, void * user_data));

void etpan_signal_remove_handler(struct etpan_signal_manager * manager,
    char * signal_name, void * sender, void * user_data,
    void (* signal_handler)(char * signal_name, void * sender,
        void * signal_data, void * user_data));

void etpan_signal_send(struct etpan_signal_manager * manager,
    char * signal_name, void * sender, void * signal_data);

struct etpan_signal_manager * etpan_signal_manager_get_default(void);
void etpan_signal_manager_set_default(struct etpan_signal_manager * manager);

#endif
