#ifndef ETPAN_SQLDB_H

#define ETPAN_SQLDB_H

#include "etpan-sqldb-types.h"

#include <libetpan/libetpan.h>

struct etpan_sqldb * etpan_sqldb_new(const char * filename,
    carray * column_list);
void etpan_sqldb_free(struct etpan_sqldb * sqldb);

int etpan_sqldb_open(struct etpan_sqldb * sqldb);
void etpan_sqldb_close(struct etpan_sqldb * sqldb);

int etpan_sqldb_get(struct etpan_sqldb * sqldb,
    char * uid, char * column,
    void ** p_data, size_t * p_len);
int etpan_sqldb_set(struct etpan_sqldb * sqldb,
    char * uid, char * column,
    void * data, size_t len);
int etpan_sqldb_delete(struct etpan_sqldb * sqldb, char * uid);
int etpan_sqldb_reset(struct etpan_sqldb * sqldb);

int etpan_sqldb_begin_transaction(struct etpan_sqldb * sqldb);
int etpan_sqldb_end_transaction(struct etpan_sqldb * sqldb);

carray * etpan_sqldb_get_keys(struct etpan_sqldb * sqldb);
void etpan_sqldb_keys_free(carray * keys);

#endif
