#ifndef ETPAN_STORAGE_FOLDER_ORDER_H

#define ETPAN_STORAGE_FOLDER_ORDER_H

#include "etpan-storage-folder-order-types.h"

struct etpan_storage_folder_order * etpan_storage_folder_order_new(void);
void etpan_storage_folder_order_free(struct etpan_storage_folder_order * folder_order);

void etpan_storage_folder_order_set_storage(struct etpan_storage_folder_order * folder_order, struct etpan_storage * storage);
struct etpan_storage * etpan_storage_folder_order_get_storage(struct etpan_storage_folder_order * folder_order);

void etpan_storage_folder_order_setup(struct etpan_storage_folder_order * folder_order);
void etpan_storage_folder_order_unsetup(struct etpan_storage_folder_order * folder_order);

void etpan_storage_folder_order_set_folder_order(struct etpan_storage_folder_order * folder_order, carray * list);
carray * etpan_storage_folder_order_get_folder_order(struct etpan_storage_folder_order * folder_order);

struct etpan_folder * etpan_storage_folder_order_get_folder(struct etpan_storage_folder_order * folder_order, char * ui_path);

void etpan_storage_folder_order_set_path(struct etpan_storage_folder_order * folder_order,
    char * path);
char * etpan_storage_folder_order_get_path(struct etpan_storage_folder_order * folder_order);

char * etpan_storage_folder_order_get_path_for_storage(struct etpan_storage_folder_order * folder_order, struct etpan_storage * storage);

#endif
