#ifndef ETPAN_STORAGE_TYPES_H

#define ETPAN_STORAGE_TYPES_H

#include <libetpan/libetpan.h>

#include "etpan-error-types.h"

#define ETPAN_STORAGE_FOLDERLIST_UPDATED \
  "org.etpan.storage.folderlist-updated"

struct etpan_storage;
struct etpan_folder;

struct etpan_storage_driver {
  char * name;
  
  int network;
  
  struct etpan_error * (* setup)(struct etpan_storage * storage) WARN_UNUSED_RESULT;
  struct etpan_error * (* create_folder)(struct etpan_storage * storage,
      char * folder_name) WARN_UNUSED_RESULT;
  struct etpan_error * (* delete_folder)(struct etpan_storage * storage,
      char * folder_name) WARN_UNUSED_RESULT;
  struct etpan_error * (* rename_folder)(struct etpan_storage * storage,
      char * folder_name, char * new_name) WARN_UNUSED_RESULT;
  struct etpan_error * (* fetch_folder_list)(struct etpan_storage * storage,
      chash * folder_list) WARN_UNUSED_RESULT;
  struct etpan_error * (* connect)(struct etpan_storage * storage) WARN_UNUSED_RESULT;
  void (* disconnect)(struct etpan_storage * storage);
  void (* free_data)(struct etpan_storage * storage);
  
  char * (* get_sub_folder_location)(struct etpan_storage * storage,
      struct etpan_folder * parent, char * name);
  
  int (* allows_sub_folders)(struct etpan_storage * storage,
      struct etpan_folder * parent);
};

struct etpan_storage {
  int ref_count;
  struct etpan_account * account;
  
  char * id;
  
  int lost;
  
  int folder_list_fetched;
  chash * folder_list;
  chash * connected_folder_list;
  
  char * cache_path;
  char * flags_path;
  char * threaded_cache_path;
  char * threaded_flags_path;
  void * data;
  struct etpan_storage_driver * driver;
  
  int connected;
};

struct etpan_storage_create_folder_result {
  struct etpan_error * error;
};

struct etpan_storage_delete_folder_result {
  struct etpan_error * error;
};

struct etpan_storage_rename_folder_result {
  struct etpan_error * error;
};

struct etpan_storage_fetch_folder_list_result {
  struct etpan_error * error;
  chash * folder_list;
};

#endif
